/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.INumeric;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;

public final class BytePointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    public static final ITypeTraits TYPE_TRAITS = new ITypeTraits(){
        private static final long serialVersionUID = 1L;

        public boolean isFixedLength() {
            return true;
        }

        public int getFixedLength() {
            return 1;
        }
    };
    public static final IPointableFactory FACTORY = new IPointableFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new BytePointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }
    };

    public static byte getByte(byte[] bytes, int start) {
        return bytes[start];
    }

    public static void setByte(byte[] bytes, int start, byte value) {
        bytes[start] = value;
    }

    public byte getByte() {
        return BytePointable.getByte(this.bytes, this.start);
    }

    public void setByte(byte value) {
        BytePointable.setByte(this.bytes, this.start, value);
    }

    public byte preIncrement() {
        byte v = this.getByte();
        v = (byte)(v + 1);
        this.setByte(v);
        return v;
    }

    public byte postIncrement() {
        byte v;
        byte by = v = this.getByte();
        v = (byte)(v + 1);
        byte ov = by;
        this.setByte(v);
        return ov;
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        byte ob;
        byte b = this.getByte();
        return b < (ob = BytePointable.getByte(bytes, start)) ? -1 : (b > ob ? 1 : 0);
    }

    @Override
    public int hash() {
        return this.getByte();
    }

    @Override
    public byte byteValue() {
        return this.getByte();
    }

    @Override
    public short shortValue() {
        return this.getByte();
    }

    @Override
    public int intValue() {
        return this.getByte();
    }

    @Override
    public long longValue() {
        return this.getByte();
    }

    @Override
    public float floatValue() {
        return this.getByte();
    }

    @Override
    public double doubleValue() {
        return this.getByte();
    }
}

