/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.tuples;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleReference;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

public class TypeAwareTupleWriter
implements ITreeIndexTupleWriter {
    protected final ITypeTraits[] typeTraits;
    protected VarLenIntEncoderDecoder.VarLenIntDecoder decoder = VarLenIntEncoderDecoder.createDecoder();

    public TypeAwareTupleWriter(ITypeTraits[] typeTraits) {
        this.typeTraits = typeTraits;
    }

    @Override
    public int bytesRequired(ITupleReference tuple) {
        int bytes = this.getNullFlagsBytes(tuple) + this.getFieldSlotsBytes(tuple);
        for (int i = 0; i < tuple.getFieldCount(); ++i) {
            bytes += tuple.getFieldLength(i);
        }
        return bytes;
    }

    @Override
    public int bytesRequired(ITupleReference tuple, int startField, int numFields) {
        int bytes = this.getNullFlagsBytes(numFields) + this.getFieldSlotsBytes(tuple, startField, numFields);
        for (int i = startField; i < startField + numFields; ++i) {
            bytes += tuple.getFieldLength(i);
        }
        return bytes;
    }

    @Override
    public ITreeIndexTupleReference createTupleReference() {
        return new TypeAwareTupleReference(this.typeTraits);
    }

    @Override
    public int writeTuple(ITupleReference tuple, ByteBuffer targetBuf, int targetOff) {
        return this.writeTuple(tuple, targetBuf.array(), targetOff);
    }

    @Override
    public int writeTuple(ITupleReference tuple, byte[] targetBuf, int targetOff) {
        int i;
        int runner = targetOff;
        int nullFlagsBytes = this.getNullFlagsBytes(tuple);
        for (i = 0; i < nullFlagsBytes; ++i) {
            targetBuf[runner++] = 0;
        }
        for (i = 0; i < tuple.getFieldCount(); ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            runner += VarLenIntEncoderDecoder.encode((int)tuple.getFieldLength(i), (byte[])targetBuf, (int)runner);
        }
        for (i = 0; i < tuple.getFieldCount(); ++i) {
            System.arraycopy(tuple.getFieldData(i), tuple.getFieldStart(i), targetBuf, runner, tuple.getFieldLength(i));
            runner += tuple.getFieldLength(i);
        }
        return runner - targetOff;
    }

    @Override
    public int writeTupleFields(ITupleReference tuple, int startField, int numFields, byte[] targetBuf, int targetOff) {
        int i;
        int runner = targetOff;
        int nullFlagsBytes = this.getNullFlagsBytes(numFields);
        for (i = 0; i < nullFlagsBytes; ++i) {
            targetBuf[runner++] = 0;
        }
        for (i = startField; i < startField + numFields; ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            runner += VarLenIntEncoderDecoder.encode((int)tuple.getFieldLength(i), (byte[])targetBuf, (int)runner);
        }
        for (i = startField; i < startField + numFields; ++i) {
            System.arraycopy(tuple.getFieldData(i), tuple.getFieldStart(i), targetBuf, runner, tuple.getFieldLength(i));
            runner += tuple.getFieldLength(i);
        }
        return runner - targetOff;
    }

    protected int getNullFlagsBytes(ITupleReference tuple) {
        return (int)Math.ceil((double)tuple.getFieldCount() / 8.0);
    }

    protected int getFieldSlotsBytes(ITupleReference tuple) {
        int fieldSlotBytes = 0;
        for (int i = 0; i < tuple.getFieldCount(); ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            fieldSlotBytes += VarLenIntEncoderDecoder.getBytesRequired((int)tuple.getFieldLength(i));
        }
        return fieldSlotBytes;
    }

    protected int getNullFlagsBytes(int numFields) {
        return (int)Math.ceil((double)numFields / 8.0);
    }

    protected int getFieldSlotsBytes(ITupleReference tuple, int startField, int numFields) {
        int fieldSlotBytes = 0;
        for (int i = startField; i < startField + numFields; ++i) {
            if (this.typeTraits[i].isFixedLength()) continue;
            fieldSlotBytes += VarLenIntEncoderDecoder.getBytesRequired((int)tuple.getFieldLength(i));
        }
        return fieldSlotBytes;
    }

    public ITypeTraits[] getTypeTraits() {
        return this.typeTraits;
    }

    @Override
    public int getCopySpaceRequired(ITupleReference tuple) {
        return this.bytesRequired(tuple);
    }
}

