/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.io.DataOutput;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.impls.TreeIndexDiskOrderScanCursor;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.LocalResource;

public class TreeIndexDiskOrderScanOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final IIndexDataflowHelper treeIndexHelper;
    private final ISearchOperationCallbackFactory searchCallbackFactory;

    public TreeIndexDiskOrderScanOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, ISearchOperationCallbackFactory searchCallbackFactory) throws HyracksDataException {
        this.ctx = ctx;
        this.treeIndexHelper = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
        this.searchCallbackFactory = searchCallbackFactory;
    }

    public void initialize() throws HyracksDataException {
        this.treeIndexHelper.open();
        ITreeIndex treeIndex = (ITreeIndex)this.treeIndexHelper.getIndexInstance();
        try {
            ITreeIndexFrame cursorFrame = treeIndex.getLeafFrameFactory().createFrame();
            TreeIndexDiskOrderScanCursor cursor = new TreeIndexDiskOrderScanCursor(cursorFrame);
            LocalResource resource = this.treeIndexHelper.getResource();
            ISearchOperationCallback searchCallback = this.searchCallbackFactory.createSearchOperationCallback(resource.getId(), this.ctx, null);
            ITreeIndexAccessor indexAccessor = (ITreeIndexAccessor)treeIndex.createAccessor(NoOpOperationCallback.INSTANCE, searchCallback);
            try {
                this.writer.open();
                indexAccessor.diskOrderScan(cursor);
                int fieldCount = treeIndex.getFieldCount();
                FrameTupleAppender appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx));
                ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
                DataOutput dos = tb.getDataOutput();
                while (cursor.hasNext()) {
                    tb.reset();
                    cursor.next();
                    ITupleReference frameTuple = cursor.getTuple();
                    for (int i = 0; i < frameTuple.getFieldCount(); ++i) {
                        dos.write(frameTuple.getFieldData(i), frameTuple.getFieldStart(i), frameTuple.getFieldLength(i));
                        tb.addFieldEndOffset();
                    }
                    FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)appender, (int[])tb.getFieldEndOffsets(), (byte[])tb.getByteArray(), (int)0, (int)tb.getSize());
                }
                appender.write(this.writer, true);
            }
            catch (Throwable th) {
                this.writer.fail();
                throw new HyracksDataException(th);
            }
            finally {
                try {
                    cursor.close();
                }
                catch (Exception cursorCloseException) {
                    throw new IllegalStateException(cursorCloseException);
                }
                finally {
                    this.writer.close();
                }
            }
        }
        catch (Throwable th) {
            this.treeIndexHelper.close();
            throw new HyracksDataException(th);
        }
    }

    public void deinitialize() throws HyracksDataException {
        this.treeIndexHelper.close();
    }
}

