/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageQueue;

public interface IBufferCache {
    public static final long INVALID_DPID = -1L;
    public static final int INVALID_PAGEID = -1;
    public static final int RESERVED_HEADER_BYTES = 8;

    public int createFile(FileReference var1) throws HyracksDataException;

    public int openFile(FileReference var1) throws HyracksDataException;

    public void openFile(int var1) throws HyracksDataException;

    public void closeFile(int var1) throws HyracksDataException;

    public void deleteFile(int var1) throws HyracksDataException;

    public void deleteFile(FileReference var1) throws HyracksDataException;

    public ICachedPage tryPin(long var1) throws HyracksDataException;

    public ICachedPage pin(long var1, boolean var3) throws HyracksDataException;

    public void unpin(ICachedPage var1) throws HyracksDataException;

    public void flushDirtyPage(ICachedPage var1) throws HyracksDataException;

    public void adviseWontNeed(ICachedPage var1);

    public ICachedPage confiscatePage(long var1) throws HyracksDataException;

    public ICachedPage confiscateLargePage(long var1, int var3, int var4) throws HyracksDataException;

    public void returnPage(ICachedPage var1);

    public void returnPage(ICachedPage var1, boolean var2);

    public void force(int var1, boolean var2) throws HyracksDataException;

    public int getPageSize();

    public int getPageSizeWithHeader();

    public int getNumPages();

    public int getNumPagesOfFile(int var1) throws HyracksDataException;

    public int getFileReferenceCount(int var1);

    public void close() throws HyracksDataException;

    public IFIFOPageQueue createFIFOQueue();

    public void finishQueue();

    public void setPageDiskId(ICachedPage var1, long var2);

    public boolean isReplicationEnabled();

    public IIOReplicationManager getIOReplicationManager();

    public void purgeHandle(int var1) throws HyracksDataException;

    public void resizePage(ICachedPage var1, int var2, IExtraPageBlockHelper var3) throws HyracksDataException;
}

