/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hyracks.util.StorageUtil;

public class DiskUtil {
    private static final Logger LOGGER = Logger.getLogger(DiskUtil.class.getName());

    private DiskUtil() {
        throw new AssertionError((Object)"Util class should not be initialized.");
    }

    public static Path mountRamDisk(String name, int size, StorageUtil.StorageUnit unit) throws IOException, InterruptedException {
        if (SystemUtils.IS_OS_MAC) {
            return DiskUtil.mountMacRamDisk(name, StorageUtil.getIntSizeInBytes(size, unit) * 2 / 1024);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return DiskUtil.mountLinuxRamDisk(name, size + unit.getLinuxUnitTypeInLetter());
        }
        throw new UnsupportedOperationException("Unsupported OS: " + System.getProperty("os.name"));
    }

    public static void unmountRamDisk(String name) throws IOException, InterruptedException {
        if (SystemUtils.IS_OS_MAC) {
            DiskUtil.unmountMacRamDisk(name);
        } else if (SystemUtils.IS_OS_LINUX) {
            DiskUtil.unmountLinuxRamDisk(name);
        }
    }

    private static Path mountMacRamDisk(String name, long size) throws IOException, InterruptedException {
        String cmd = "diskutil erasevolume HFS+ '" + name + "' `hdiutil attach -nomount ram://" + size + "`";
        ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", cmd);
        Process p = pb.start();
        DiskUtil.watchProcess(p);
        p.waitFor();
        return Paths.get("/Volumes", name);
    }

    private static void unmountMacRamDisk(String name) throws InterruptedException, IOException {
        String cmd = "diskutil unmount " + name;
        ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", cmd);
        Process p = pb.start();
        DiskUtil.watchProcess(p);
        p.waitFor();
    }

    private static Path mountLinuxRamDisk(String name, String size) throws IOException, InterruptedException {
        Path root = Paths.get("/tmp", name);
        if (!Files.exists(root, new LinkOption[0])) {
            Files.createFile(root, new FileAttribute[0]);
        }
        String cmd = "mount -o size=" + size + " -t tmpfs none /tmp/" + name;
        ProcessBuilder pb = new ProcessBuilder("bash", "-c", cmd);
        Process p = pb.start();
        DiskUtil.watchProcess(p);
        p.waitFor();
        return root;
    }

    private static void unmountLinuxRamDisk(String name) throws InterruptedException, IOException {
        String cmd = "umount /tmp/" + name;
        ProcessBuilder pb = new ProcessBuilder("bash", "-c", cmd);
        Process p = pb.start();
        DiskUtil.watchProcess(p);
        p.waitFor();
    }

    private static void watchProcess(Process p) {
        new Thread(() -> {
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    LOGGER.info(line);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }).start();
    }
}

