/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.transactions;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.replication.IReplicationThread;
import org.apache.asterix.common.transactions.ILogMarkerCallback;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.LogSource;
import org.apache.asterix.common.transactions.LogType;
import org.apache.asterix.common.transactions.PrimaryKeyTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.tuples.SimpleTupleReference;
import org.apache.hyracks.storage.am.common.tuples.SimpleTupleWriter;

public class LogRecord
implements ILogRecord {
    private byte logSource;
    private byte logType;
    private int jobId;
    private int datasetId;
    private int PKHashValue;
    private int PKValueSize;
    private ITupleReference PKValue;
    private long resourceId;
    private int resourcePartition;
    private int logSize;
    private int newValueFieldCount;
    private byte newOp;
    private int newValueSize;
    private ITupleReference newValue;
    private int oldValueSize;
    private ITupleReference oldValue;
    private int oldValueFieldCount;
    private long checksum;
    private long prevMarkerLSN;
    private ByteBuffer marker;
    private final ILogMarkerCallback callback;
    private int PKFieldCnt;
    private ITransactionContext txnCtx;
    private long LSN;
    private final AtomicBoolean isFlushed;
    private final PrimaryKeyTupleReference readPKValue;
    private final SimpleTupleReference readNewValue;
    private final SimpleTupleReference readOldValue;
    private final CRC32 checksumGen;
    private int[] PKFields;
    private PrimaryIndexOperationTracker opTracker;
    private IReplicationThread replicationThread;
    private int numOfFlushedIndexes;
    private String nodeId;
    private boolean replicated = false;

    public LogRecord(ILogMarkerCallback callback) {
        this.callback = callback;
        this.isFlushed = new AtomicBoolean(false);
        this.readPKValue = new PrimaryKeyTupleReference();
        this.readNewValue = SimpleTupleWriter.INSTANCE.createTupleReference();
        this.readOldValue = SimpleTupleWriter.INSTANCE.createTupleReference();
        this.checksumGen = new CRC32();
        this.logSource = 0;
    }

    public LogRecord() {
        this(null);
    }

    private void doWriteLogRecord(ByteBuffer buffer) {
        buffer.put(this.logSource);
        buffer.put(this.logType);
        buffer.putInt(this.jobId);
        switch (this.logType) {
            case 2: {
                this.writeEntityInfo(buffer);
                break;
            }
            case 0: {
                this.writeEntityInfo(buffer);
                buffer.putLong(this.resourceId);
                buffer.putInt(this.logSize);
                buffer.putInt(this.newValueFieldCount);
                buffer.put(this.newOp);
                buffer.putInt(this.newValueSize);
                this.writeTuple(buffer, this.newValue, this.newValueSize);
                if (this.oldValueSize <= 0) break;
                buffer.putInt(this.oldValueSize);
                buffer.putInt(this.oldValueFieldCount);
                this.writeTuple(buffer, this.oldValue, this.oldValueSize);
                break;
            }
            case 4: {
                buffer.putInt(this.datasetId);
                break;
            }
            case 7: {
                buffer.putInt(this.datasetId);
                buffer.putInt(this.resourcePartition);
                this.callback.before(buffer);
                buffer.putInt(this.logSize);
                buffer.put(this.marker);
                break;
            }
        }
    }

    private void writeEntityInfo(ByteBuffer buffer) {
        buffer.putInt(this.resourcePartition);
        buffer.putInt(this.datasetId);
        buffer.putInt(this.PKHashValue);
        if (this.PKValueSize <= 0) {
            throw new IllegalStateException("Primary Key Size is less than or equal to 0");
        }
        buffer.putInt(this.PKValueSize);
        this.writePKValue(buffer);
    }

    @Override
    public void writeLogRecord(ByteBuffer buffer) {
        int beginOffset = buffer.position();
        this.doWriteLogRecord(buffer);
        this.checksum = this.generateChecksum(buffer, beginOffset, this.logSize - 8);
        buffer.putLong(this.checksum);
    }

    @Override
    public void writeRemoteLogRecord(ByteBuffer buffer) {
        this.doWriteLogRecord(buffer);
        if (this.logType == 4) {
            buffer.putLong(this.LSN);
            buffer.putInt(this.numOfFlushedIndexes);
            buffer.putInt(this.nodeId.length());
            buffer.put(this.nodeId.getBytes());
        }
    }

    private void writePKValue(ByteBuffer buffer) {
        if (this.logSource == 0) {
            for (int i = 0; i < this.PKFieldCnt; ++i) {
                buffer.put(this.PKValue.getFieldData(0), this.PKValue.getFieldStart(this.PKFields[i]), this.PKValue.getFieldLength(this.PKFields[i]));
            }
        } else {
            buffer.put(this.PKValue.getFieldData(0), 0, this.PKValueSize);
        }
    }

    private void writeTuple(ByteBuffer buffer, ITupleReference tuple, int size) {
        SimpleTupleWriter.INSTANCE.writeTuple(tuple, buffer.array(), buffer.position());
        buffer.position(buffer.position() + size);
    }

    private long generateChecksum(ByteBuffer buffer, int offset, int len) {
        this.checksumGen.reset();
        this.checksumGen.update(buffer.array(), offset, len);
        return this.checksumGen.getValue();
    }

    @Override
    public ILogRecord.RecordReadStatus readLogRecord(ByteBuffer buffer) {
        int beginOffset = buffer.position();
        ILogRecord.RecordReadStatus status = this.doReadLogRecord(buffer);
        if (status != ILogRecord.RecordReadStatus.OK) {
            buffer.position(beginOffset);
            return status;
        }
        if (buffer.remaining() < 8) {
            buffer.position(beginOffset);
            return ILogRecord.RecordReadStatus.TRUNCATED;
        }
        this.checksum = buffer.getLong();
        if (this.checksum != this.generateChecksum(buffer, beginOffset, this.logSize - 8)) {
            return ILogRecord.RecordReadStatus.BAD_CHKSUM;
        }
        return ILogRecord.RecordReadStatus.OK;
    }

    private ILogRecord.RecordReadStatus doReadLogRecord(ByteBuffer buffer) {
        if (buffer.remaining() < 6) {
            return ILogRecord.RecordReadStatus.TRUNCATED;
        }
        this.logSource = buffer.get();
        this.logType = buffer.get();
        this.jobId = buffer.getInt();
        switch (this.logType) {
            case 4: {
                if (buffer.remaining() < 4) {
                    return ILogRecord.RecordReadStatus.TRUNCATED;
                }
                this.datasetId = buffer.getInt();
                this.resourceId = 0L;
            }
            case 6: {
                this.computeAndSetLogSize();
                break;
            }
            case 1: 
            case 3: {
                this.datasetId = -1;
                this.PKHashValue = -1;
                this.computeAndSetLogSize();
                break;
            }
            case 2: {
                if (this.readEntityInfo(buffer)) {
                    this.computeAndSetLogSize();
                    break;
                }
                return ILogRecord.RecordReadStatus.TRUNCATED;
            }
            case 0: {
                if (this.readEntityInfo(buffer)) {
                    if (buffer.remaining() < 21) {
                        return ILogRecord.RecordReadStatus.TRUNCATED;
                    }
                    this.resourceId = buffer.getLong();
                    this.logSize = buffer.getInt();
                    this.newValueFieldCount = buffer.getInt();
                    this.newOp = buffer.get();
                    this.newValueSize = buffer.getInt();
                    if (buffer.remaining() < this.newValueSize) {
                        if (this.logSize > buffer.capacity()) {
                            return ILogRecord.RecordReadStatus.LARGE_RECORD;
                        }
                        return ILogRecord.RecordReadStatus.TRUNCATED;
                    }
                    this.newValue = LogRecord.readTuple(buffer, this.readNewValue, this.newValueFieldCount, this.newValueSize);
                    if (this.logSize > this.getUpdateLogSizeWithoutOldValue()) {
                        if (buffer.remaining() < 4) {
                            return ILogRecord.RecordReadStatus.TRUNCATED;
                        }
                        this.oldValueSize = buffer.getInt();
                        if (buffer.remaining() < 4) {
                            return ILogRecord.RecordReadStatus.TRUNCATED;
                        }
                        this.oldValueFieldCount = buffer.getInt();
                        if (buffer.remaining() < this.oldValueSize) {
                            return ILogRecord.RecordReadStatus.TRUNCATED;
                        }
                        this.oldValue = LogRecord.readTuple(buffer, this.readOldValue, this.oldValueFieldCount, this.oldValueSize);
                        break;
                    }
                    this.oldValueSize = 0;
                    this.oldValue = null;
                    break;
                }
                return ILogRecord.RecordReadStatus.TRUNCATED;
            }
            case 7: {
                if (buffer.remaining() < 20) {
                    return ILogRecord.RecordReadStatus.TRUNCATED;
                }
                this.datasetId = buffer.getInt();
                this.resourcePartition = buffer.getInt();
                this.prevMarkerLSN = buffer.getLong();
                this.logSize = buffer.getInt();
                int lenRemaining = this.logSize - 34;
                if (buffer.remaining() < lenRemaining) {
                    return ILogRecord.RecordReadStatus.TRUNCATED;
                }
                if (this.marker == null || this.marker.capacity() < lenRemaining) {
                    this.marker = ByteBuffer.allocate(lenRemaining + 2);
                }
                this.marker.clear();
                buffer.get(this.marker.array(), 0, lenRemaining);
                this.marker.position(lenRemaining);
                this.marker.flip();
                break;
            }
        }
        return ILogRecord.RecordReadStatus.OK;
    }

    private boolean readEntityInfo(ByteBuffer buffer) {
        if (buffer.remaining() < 16) {
            return false;
        }
        this.resourcePartition = buffer.getInt();
        this.datasetId = buffer.getInt();
        this.PKHashValue = buffer.getInt();
        this.PKValueSize = buffer.getInt();
        if (buffer.remaining() < this.PKValueSize) {
            return false;
        }
        if (this.PKValueSize <= 0) {
            throw new IllegalStateException("Primary Key Size is less than or equal to 0");
        }
        this.PKValue = this.readPKValue(buffer);
        return true;
    }

    @Override
    public void readRemoteLog(ByteBuffer buffer) {
        this.doReadLogRecord(buffer);
        if (this.logType == 4) {
            this.LSN = buffer.getLong();
            this.numOfFlushedIndexes = buffer.getInt();
            int nodeIdLength = buffer.getInt();
            byte[] nodeIdBytes = new byte[nodeIdLength];
            buffer.get(nodeIdBytes);
            this.nodeId = new String(nodeIdBytes);
        }
    }

    private ITupleReference readPKValue(ByteBuffer buffer) {
        if (buffer.position() + this.PKValueSize > buffer.limit()) {
            throw new BufferUnderflowException();
        }
        this.readPKValue.reset(buffer.array(), buffer.position(), this.PKValueSize);
        buffer.position(buffer.position() + this.PKValueSize);
        return this.readPKValue;
    }

    private static ITupleReference readTuple(ByteBuffer srcBuffer, SimpleTupleReference destTuple, int fieldCnt, int size) {
        if (srcBuffer.position() + size > srcBuffer.limit()) {
            throw new BufferUnderflowException();
        }
        destTuple.setFieldCount(fieldCnt);
        destTuple.resetByTupleOffset(srcBuffer.array(), srcBuffer.position());
        srcBuffer.position(srcBuffer.position() + size);
        return destTuple;
    }

    @Override
    public void computeAndSetPKValueSize() {
        this.PKValueSize = 0;
        for (int i = 0; i < this.PKFieldCnt; ++i) {
            this.PKValueSize += this.PKValue.getFieldLength(this.PKFields[i]);
        }
    }

    private void setUpdateLogSize() {
        this.logSize = this.getUpdateLogSizeWithoutOldValue();
        if (this.oldValueSize > 0) {
            this.logSize += 8 + this.oldValueSize;
        }
    }

    private int getUpdateLogSizeWithoutOldValue() {
        return 51 + this.PKValueSize + this.newValueSize;
    }

    @Override
    public void computeAndSetLogSize() {
        switch (this.logType) {
            case 0: {
                this.setUpdateLogSize();
                break;
            }
            case 1: 
            case 3: {
                this.logSize = 14;
                break;
            }
            case 2: {
                this.logSize = 30 + this.PKValueSize;
                break;
            }
            case 4: {
                this.logSize = 18;
                break;
            }
            case 6: {
                this.logSize = 14;
                break;
            }
            case 7: {
                this.setMarkerLogSize();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported Log Type");
            }
        }
    }

    private void setMarkerLogSize() {
        this.logSize = 34 + this.marker.remaining();
    }

    @Override
    public String getLogRecordForDisplay() {
        StringBuilder builder = new StringBuilder();
        builder.append(" Source : ").append(LogSource.toString(this.logSource));
        builder.append(" LSN : ").append(this.LSN);
        builder.append(" LogType : ").append(LogType.toString(this.logType));
        builder.append(" LogSize : ").append(this.logSize);
        builder.append(" JobId : ").append(this.jobId);
        if (this.logType == 2 || this.logType == 0) {
            builder.append(" DatasetId : ").append(this.datasetId);
            builder.append(" ResourcePartition : ").append(this.resourcePartition);
            builder.append(" PKHashValue : ").append(this.PKHashValue);
            builder.append(" PKFieldCnt : ").append(this.PKFieldCnt);
            builder.append(" PKSize: ").append(this.PKValueSize);
        }
        if (this.logType == 0) {
            builder.append(" ResourceId : ").append(this.resourceId);
        }
        return builder.toString();
    }

    @Override
    public ITransactionContext getTxnCtx() {
        return this.txnCtx;
    }

    @Override
    public void setTxnCtx(ITransactionContext txnCtx) {
        this.txnCtx = txnCtx;
    }

    @Override
    public boolean isFlushed() {
        return this.isFlushed.get();
    }

    @Override
    public void isFlushed(boolean isFlushed) {
        this.isFlushed.set(isFlushed);
    }

    @Override
    public byte getLogType() {
        return this.logType;
    }

    @Override
    public void setLogType(byte logType) {
        this.logType = logType;
    }

    @Override
    public int getJobId() {
        return this.jobId;
    }

    @Override
    public void setJobId(int jobId) {
        this.jobId = jobId;
    }

    @Override
    public int getDatasetId() {
        return this.datasetId;
    }

    @Override
    public void setDatasetId(int datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    public int getPKHashValue() {
        return this.PKHashValue;
    }

    @Override
    public void setPKHashValue(int PKHashValue) {
        this.PKHashValue = PKHashValue;
    }

    @Override
    public long getResourceId() {
        return this.resourceId;
    }

    @Override
    public void setResourceId(long resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public int getLogSize() {
        return this.logSize;
    }

    @Override
    public int getRemoteLogSize() {
        int remoteLogSize = this.logSize;
        if (this.logType == 4) {
            remoteLogSize += 8;
            remoteLogSize += 4;
            remoteLogSize += 4 + this.nodeId.length();
        }
        return remoteLogSize -= 8;
    }

    @Override
    public void setLogSize(int logSize) {
        this.logSize = logSize;
    }

    @Override
    public byte getNewOp() {
        return this.newOp;
    }

    @Override
    public void setNewOp(byte newOp) {
        this.newOp = newOp;
    }

    @Override
    public void setNewValueSize(int newValueSize) {
        this.newValueSize = newValueSize;
    }

    @Override
    public ITupleReference getNewValue() {
        return this.newValue;
    }

    @Override
    public void setNewValue(ITupleReference newValue) {
        this.newValue = newValue;
        this.newValueFieldCount = newValue.getFieldCount();
    }

    @Override
    public long getChecksum() {
        return this.checksum;
    }

    @Override
    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    @Override
    public long getLSN() {
        return this.LSN;
    }

    @Override
    public void setLSN(long LSN) {
        this.LSN = LSN;
    }

    @Override
    public int getPKValueSize() {
        return this.PKValueSize;
    }

    @Override
    public ITupleReference getPKValue() {
        return this.PKValue;
    }

    @Override
    public void setPKFields(int[] primaryKeyFields) {
        this.PKFields = primaryKeyFields;
        this.PKFieldCnt = this.PKFields.length;
    }

    @Override
    public void setPKValue(ITupleReference PKValue) {
        this.PKValue = PKValue;
    }

    public PrimaryIndexOperationTracker getOpTracker() {
        return this.opTracker;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public IReplicationThread getReplicationThread() {
        return this.replicationThread;
    }

    @Override
    public void setReplicationThread(IReplicationThread replicationThread) {
        this.replicationThread = replicationThread;
    }

    @Override
    public void setLogSource(byte logSource) {
        this.logSource = logSource;
    }

    @Override
    public byte getLogSource() {
        return this.logSource;
    }

    public int getNumOfFlushedIndexes() {
        return this.numOfFlushedIndexes;
    }

    public void setNumOfFlushedIndexes(int numOfFlushedIndexes) {
        this.numOfFlushedIndexes = numOfFlushedIndexes;
    }

    public void setPKFieldCnt(int pKFieldCnt) {
        this.PKFieldCnt = pKFieldCnt;
    }

    public void setOpTracker(PrimaryIndexOperationTracker opTracker) {
        this.opTracker = opTracker;
    }

    @Override
    public int getResourcePartition() {
        return this.resourcePartition;
    }

    @Override
    public void setResourcePartition(int resourcePartition) {
        this.resourcePartition = resourcePartition;
    }

    @Override
    public void setReplicated(boolean replicate) {
        this.replicated = replicate;
    }

    @Override
    public boolean isReplicated() {
        return this.replicated;
    }

    @Override
    public ITupleReference getOldValue() {
        return this.oldValue;
    }

    @Override
    public void setOldValue(ITupleReference oldValue) {
        this.oldValue = oldValue;
        this.oldValueFieldCount = oldValue.getFieldCount();
    }

    @Override
    public void setOldValueSize(int oldValueSize) {
        this.oldValueSize = oldValueSize;
    }

    public void setMarker(ByteBuffer marker) {
        this.marker = marker;
    }

    @Override
    public boolean isMarker() {
        return this.logType == 7;
    }

    @Override
    public void logAppended(long lsn) {
        this.callback.after(lsn);
    }

    @Override
    public long getPreviousMarkerLSN() {
        return this.prevMarkerLSN;
    }

    @Override
    public ByteBuffer getMarker() {
        return this.marker;
    }
}

