/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.replication;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.Replica;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class MetadataOnlyReplicationStrategy
implements IReplicationStrategy {
    private String metadataNodeId;
    private Replica metadataPrimaryReplica;
    private Set<Replica> metadataNodeReplicas;

    @Override
    public boolean isMatch(int datasetId) {
        return datasetId < 100 && datasetId >= 0;
    }

    @Override
    public Set<Replica> getRemoteReplicas(String nodeId) {
        if (nodeId.equals(this.metadataNodeId)) {
            return this.metadataNodeReplicas;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Replica> getRemotePrimaryReplicas(String nodeId) {
        if (this.metadataNodeReplicas.stream().map(Replica::getId).filter(replicaId -> replicaId.equals(nodeId)).count() != 0L) {
            return new HashSet<Replica>(Arrays.asList(this.metadataPrimaryReplica));
        }
        return Collections.emptySet();
    }

    @Override
    public MetadataOnlyReplicationStrategy from(Cluster cluster) throws HyracksDataException {
        if (cluster.getMetadataNode() == null) {
            throw new RuntimeDataException(4004, new Serializable[]{"Metadata node must be specified."});
        }
        Node metadataNode = ClusterProperties.INSTANCE.getNodeById(cluster.getMetadataNode());
        if (metadataNode == null) {
            throw new IllegalStateException("Invalid metadata node specified");
        }
        if (cluster.getHighAvailability().getFaultTolerance().getReplica() == null || cluster.getHighAvailability().getFaultTolerance().getReplica().getNodeId() == null || cluster.getHighAvailability().getFaultTolerance().getReplica().getNodeId().isEmpty()) {
            throw new RuntimeDataException(4004, new Serializable[]{"One or more replicas must be specified for metadata node."});
        }
        HashSet<Replica> replicas = new HashSet<Replica>();
        for (String nodeId : cluster.getHighAvailability().getFaultTolerance().getReplica().getNodeId()) {
            Node node = ClusterProperties.INSTANCE.getNodeById(nodeId);
            if (node == null) {
                throw new RuntimeDataException(4004, new Serializable[]{"Invalid replica specified: " + nodeId});
            }
            replicas.add(new Replica(node));
        }
        MetadataOnlyReplicationStrategy st = new MetadataOnlyReplicationStrategy();
        st.metadataNodeId = cluster.getMetadataNode();
        st.metadataPrimaryReplica = new Replica(metadataNode);
        st.metadataNodeReplicas = replicas;
        return st;
    }
}

