/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.ioopcallbacks;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.freepage.MutableArrayValueReference;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMDiskComponentId;
import org.apache.hyracks.storage.am.lsm.common.utils.ComponentMetadataUtil;

public abstract class AbstractLSMIOOperationCallback
implements ILSMIOOperationCallback {
    private static final Logger logger = Logger.getLogger(AbstractLSMIOOperationCallback.class.getName());
    public static final MutableArrayValueReference LSN_KEY = new MutableArrayValueReference("LSN".getBytes());
    public static final long INVALID = -1L;
    protected long[] firstLSNs;
    protected boolean[] flushRequested;
    protected long[] mutableLastLSNs;
    protected int readIndex;
    protected int writeIndex;

    public void setNumOfMutableComponents(int count) {
        this.mutableLastLSNs = new long[count];
        this.firstLSNs = new long[count];
        this.flushRequested = new boolean[count];
        this.readIndex = 0;
        this.writeIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeOperation(LSMOperationType opType) {
        if (opType == LSMOperationType.FLUSH) {
            AbstractLSMIOOperationCallback abstractLSMIOOperationCallback = this;
            synchronized (abstractLSMIOOperationCallback) {
                this.flushRequested[this.writeIndex] = true;
                this.writeIndex = (this.writeIndex + 1) % this.mutableLastLSNs.length;
                if (this.writeIndex != this.readIndex) {
                    this.firstLSNs[this.writeIndex] = this.mutableLastLSNs[this.writeIndex];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterFinalize(LSMOperationType opType, ILSMDiskComponent newComponent) {
        if (opType == LSMOperationType.FLUSH && newComponent != null) {
            AbstractLSMIOOperationCallback abstractLSMIOOperationCallback = this;
            synchronized (abstractLSMIOOperationCallback) {
                this.flushRequested[this.readIndex] = false;
                if (this.readIndex == this.writeIndex) {
                    this.firstLSNs[this.writeIndex] = this.mutableLastLSNs[this.writeIndex];
                }
                this.readIndex = (this.readIndex + 1) % this.mutableLastLSNs.length;
            }
        }
    }

    public void putLSNIntoMetadata(ILSMDiskComponent index, List<ILSMComponent> oldComponents) throws HyracksDataException {
        index.getMetadata().put((IValueReference)LSN_KEY, (IValueReference)LongPointable.FACTORY.createPointable(this.getComponentLSN(oldComponents)));
    }

    public static long getTreeIndexLSN(DiskComponentMetadata md) throws HyracksDataException {
        LongPointable pointable = new LongPointable();
        IMetadataPageManager metadataPageManager = md.getMetadataPageManager();
        metadataPageManager.get(metadataPageManager.createMetadataFrame(), (IValueReference)LSN_KEY, (IPointable)pointable);
        return pointable.getLength() == 0 ? -1L : pointable.longValue();
    }

    private ILSMDiskComponentId getComponentId(List<ILSMComponent> oldComponents) throws HyracksDataException {
        if (oldComponents == null) {
            long id = this.getComponentLSN(null);
            if (id == 0L) {
                logger.log(Level.WARNING, "Flushing a memory component without setting the LSN");
                id = -1L;
            }
            return new LSMDiskComponentId(id, id);
        }
        long minId = Long.MAX_VALUE;
        long maxId = Long.MIN_VALUE;
        for (ILSMComponent oldComponent : oldComponents) {
            ILSMDiskComponentId oldComponentId = ((ILSMDiskComponent)oldComponent).getComponentId();
            if (oldComponentId.getMinId() < minId) {
                minId = oldComponentId.getMinId();
            }
            if (oldComponentId.getMaxId() <= maxId) continue;
            maxId = oldComponentId.getMaxId();
        }
        return new LSMDiskComponentId(minId, maxId);
    }

    private void putComponentIdIntoMetadata(ILSMDiskComponent component, List<ILSMComponent> oldComponents) throws HyracksDataException {
        DiskComponentMetadata metadata = component.getMetadata();
        ILSMDiskComponentId componentId = this.getComponentId(oldComponents);
        metadata.put((IValueReference)ILSMDiskComponentId.COMPONENT_ID_MIN_KEY, (IValueReference)LongPointable.FACTORY.createPointable(componentId.getMinId()));
        metadata.put((IValueReference)ILSMDiskComponentId.COMPONENT_ID_MAX_KEY, (IValueReference)LongPointable.FACTORY.createPointable(componentId.getMaxId()));
    }

    public synchronized void updateLastLSN(long lastLSN) {
        if (!this.flushRequested[this.writeIndex]) {
            this.mutableLastLSNs[this.writeIndex] = lastLSN;
        }
    }

    public void setFirstLSN(long firstLSN) {
        this.firstLSNs[this.writeIndex] = firstLSN;
    }

    public synchronized long getFirstLSN() {
        return this.firstLSNs[this.readIndex];
    }

    public synchronized boolean hasPendingFlush() {
        for (int i = 0; i < this.flushRequested.length; ++i) {
            if (!this.flushRequested[i]) continue;
            return true;
        }
        return false;
    }

    public final void afterOperation(LSMOperationType opType, List<ILSMComponent> oldComponents, ILSMDiskComponent newComponent) throws HyracksDataException {
        if (newComponent != null) {
            this.putLSNIntoMetadata(newComponent, oldComponents);
            this.putComponentIdIntoMetadata(newComponent, oldComponents);
            if (opType == LSMOperationType.MERGE) {
                LongPointable markerLsn = LongPointable.FACTORY.createPointable(ComponentMetadataUtil.getLong((IComponentMetadata)oldComponents.get(0).getMetadata(), (IValueReference)ComponentMetadataUtil.MARKER_LSN_KEY, (long)-1L));
                newComponent.getMetadata().put((IValueReference)ComponentMetadataUtil.MARKER_LSN_KEY, (IValueReference)markerLsn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getComponentLSN(List<? extends ILSMComponent> diskComponents) throws HyracksDataException {
        if (diskComponents == null) {
            AbstractLSMIOOperationCallback abstractLSMIOOperationCallback = this;
            synchronized (abstractLSMIOOperationCallback) {
                long lsn = this.mutableLastLSNs[this.readIndex];
                return lsn;
            }
        }
        long maxLSN = -1L;
        for (ILSMComponent iLSMComponent : diskComponents) {
            DiskComponentMetadata md = ((ILSMDiskComponent)iLSMComponent).getMetadata();
            maxLSN = Math.max(AbstractLSMIOOperationCallback.getTreeIndexLSN(md), maxLSN);
        }
        return maxLSN;
    }

    public abstract long getComponentFileLSNOffset(ILSMDiskComponent var1, String var2) throws HyracksDataException;
}

