/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.logging.Level;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;

public class ExternalProperties
extends AbstractProperties {
    public ExternalProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public int getWebInterfacePort() {
        return this.accessor.getInt(Option.WEB_PORT);
    }

    public int getQueryWebInterfacePort() {
        return this.accessor.getInt(Option.WEB_QUERYINTERFACE_PORT);
    }

    public int getAPIServerPort() {
        return this.accessor.getInt(Option.API_PORT);
    }

    public int getActiveServerPort() {
        return this.accessor.getInt(Option.ACTIVE_PORT);
    }

    public Level getLogLevel() {
        return this.accessor.getLoggingLevel(Option.LOG_LEVEL);
    }

    public int getMaxWaitClusterActive() {
        return this.accessor.getInt(Option.MAX_WAIT_ACTIVE_CLUSTER);
    }

    public String getNCJavaParams() {
        return this.accessor.getString(Option.NC_JAVA_OPTS);
    }

    public String getCCJavaParams() {
        return this.accessor.getString(Option.CC_JAVA_OPTS);
    }

    public static enum Option implements IOption
    {
        WEB_PORT(OptionTypes.INTEGER, 19001, "The listen port of the legacy query interface"),
        WEB_QUERYINTERFACE_PORT(OptionTypes.INTEGER, 19006, "The listen port of the query web interface"),
        API_PORT(OptionTypes.INTEGER, 19002, "The listen port of the API server"),
        ACTIVE_PORT(OptionTypes.INTEGER, 19003, "The listen port of the active server"),
        LOG_LEVEL(OptionTypes.LEVEL, Level.WARNING, "The logging level for master and slave processes"),
        MAX_WAIT_ACTIVE_CLUSTER(OptionTypes.INTEGER, 60, "The max pending time (in seconds) for cluster startup. After the threshold, if the cluster still is not up and running, it is considered unavailable"),
        CC_JAVA_OPTS(OptionTypes.STRING, "-Xmx1024m", "The JVM options passed to the cluster controller process by managix"),
        NC_JAVA_OPTS(OptionTypes.STRING, "-Xmx1024m", "The JVM options passed to the node controller process(es) by managix");

        private final IOptionType type;
        private final Object defaultValue;
        private final String description;

        private Option(IOptionType type, Object defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public Section section() {
            switch (this) {
                case WEB_PORT: 
                case WEB_QUERYINTERFACE_PORT: 
                case API_PORT: 
                case ACTIVE_PORT: {
                    return Section.CC;
                }
                case LOG_LEVEL: 
                case MAX_WAIT_ACTIVE_CLUSTER: {
                    return Section.COMMON;
                }
                case CC_JAVA_OPTS: 
                case NC_JAVA_OPTS: {
                    return Section.VIRTUAL;
                }
            }
            throw new IllegalStateException("NYI: " + (Object)((Object)this));
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }
    }
}

