/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import org.apache.asterix.event.management.AsterixEventServiceClient;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ILookupService;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.UninstallConfig;
import org.apache.asterix.installer.driver.InstallerDriver;

public class UninstallCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        UninstallConfig uninstallConfig = (UninstallConfig)this.config;
        String instanceName = uninstallConfig.name;
        AsterixEventServiceUtil.validateAsterixInstanceExists((String)instanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.INACTIVE});
        ILookupService lookupService = ServiceProvider.INSTANCE.getLookupService();
        AsterixInstance instance = lookupService.getAsterixInstance(instanceName);
        PatternCreator pc = PatternCreator.INSTANCE;
        Patterns patterns = pc.getLibraryUninstallPattern(instance, uninstallConfig.dataverseName, uninstallConfig.libraryName);
        AsterixEventServiceClient client = AsterixEventService.getAsterixEventServiceClient((Cluster)instance.getCluster());
        client.submit(patterns);
        LOGGER.info((Object)("Uninstalled library " + uninstallConfig.libraryName));
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new UninstallConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "Uninstalls a library from an asterix instance.\nArguments/Options\n-n  Name of Asterix Instance\n-d  Name of the dataverse under which the library will be installed\n-l  Name of the library\n-l  Name of the library";
    }
}

