/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.util.ArrayList;
import java.util.Date;
import org.apache.asterix.event.error.VerificationUtil;
import org.apache.asterix.event.management.AsterixEventServiceClient;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.model.AsterixRuntimeState;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.pattern.Pattern;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.StopNodeConfig;
import org.apache.asterix.installer.driver.InstallerDriver;
import org.apache.asterix.installer.error.InstallerException;

public class StopNodeCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        String asterixInstanceName = ((StopNodeConfig)this.config).name;
        AsterixInstance asterixInstance = AsterixEventServiceUtil.validateAsterixInstanceExists((String)asterixInstanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.ACTIVE, AsterixInstance.State.UNUSABLE});
        AsterixEventServiceClient client = AsterixEventService.getAsterixEventServiceClient((Cluster)asterixInstance.getCluster());
        String[] nodesToStop = ((StopNodeConfig)this.config).nodeList.split(",");
        AsterixRuntimeState runtimeState = VerificationUtil.getAsterixRuntimeState((AsterixInstance)asterixInstance);
        ArrayList<String> aliveNodes = new ArrayList<String>();
        for (Object p : runtimeState.getProcesses()) {
            aliveNodes.add(p.getNodeId());
        }
        ArrayList<String> validNodeIds = new ArrayList<String>();
        for (String[] node : asterixInstance.getCluster().getNode()) {
            validNodeIds.add(node.getId());
        }
        ArrayList<Pattern> ncKillPatterns = new ArrayList<Pattern>();
        for (String nodeId : nodesToStop) {
            if (!nodeId.contains(nodeId)) {
                throw new InstallerException("Invalid nodeId: " + nodeId);
            }
            if (!aliveNodes.contains(nodeId)) {
                throw new InstallerException("Node: " + nodeId + " is not alive");
            }
            ncKillPatterns.add(PatternCreator.INSTANCE.createNCStopPattern(nodeId, asterixInstanceName + "_" + nodeId));
        }
        try {
            client.submit(new Patterns(ncKillPatterns));
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Attempt to kill non-existing processess");
        }
        asterixInstance.setStateChangeTimestamp(new Date());
        ServiceProvider.INSTANCE.getLookupService().updateAsterixInstance(asterixInstance);
        LOGGER.info((Object)("Stopped nodes " + ((StopNodeConfig)this.config).nodeList + " serving Asterix instance: " + asterixInstanceName));
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new StopNodeConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "\nStops a specified set of ASTERIX nodes.\n\nAvailable arguments/options\n-n name of the ASTERIX instance. \n-nodes Comma separated list of nodes that need to be stopped. ";
    }
}

