/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.InstallConfig;
import org.apache.asterix.installer.driver.InstallerDriver;

public class InstallCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        InstallConfig installConfig = (InstallConfig)this.config;
        String instanceName = installConfig.name;
        AsterixInstance instance = AsterixEventServiceUtil.validateAsterixInstanceExists((String)instanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.INACTIVE});
        PatternCreator pc = PatternCreator.INSTANCE;
        Patterns patterns = pc.getLibraryInstallPattern(instance, installConfig.dataverseName, installConfig.libraryName, installConfig.libraryPath);
        AsterixEventService.getAsterixEventServiceClient((Cluster)instance.getCluster()).submit(patterns);
        LOGGER.info((Object)("Installed library " + installConfig.libraryName));
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new InstallConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "Installs a library to an asterix instance.\nArguments/Options\n-n  Name of Asterix Instance\n-d  Name of the dataverse under which the library will be installed\n-l  Name of the library\n-p  Path to library zip bundle";
    }
}

