/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.apache.asterix.event.management.EventUtil;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.event.schema.cluster.WorkingDir;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.ConfigureConfig;
import org.apache.asterix.installer.driver.InstallerDriver;
import org.apache.asterix.installer.schema.conf.Configuration;

public class ConfigureCommand
extends AbstractCommand {
    private static final String WORK_DIR = "/tmp/asterix";

    @Override
    protected void execCommand() throws Exception {
        this.configureCluster("local", "local.xml");
        this.configureCluster("local", "local_chained_declustering_rep.xml");
        this.configureCluster("local", "local_metadata_only_rep.xml");
        this.configureCluster("demo", "demo.xml");
        String installerConfPath = InstallerDriver.getManagixHome() + File.separator + InstallerDriver.MANAGIX_CONF_XML;
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        Configuration configuration = (Configuration)unmarshaller.unmarshal(new File(installerConfPath));
        configuration.setConfigured(true);
        configuration.getBackup().setBackupDir(InstallerDriver.getManagixHome() + File.separator + "backup");
        configuration.getZookeeper().setHomeDir(InstallerDriver.getManagixHome() + File.separator + ".installer" + File.separator + "zookeeper_home");
        configuration.getZookeeper().getServers().setJavaHome(System.getProperty("java.home"));
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)configuration, (OutputStream)new FileOutputStream(installerConfPath));
    }

    private void configureCluster(String dir, String file) throws JAXBException, PropertyException, FileNotFoundException {
        String clusterDir = InstallerDriver.getManagixHome() + File.separator + "clusters" + File.separator + dir;
        String localClusterPath = clusterDir + File.separator + file;
        if (!Files.exists(Paths.get(localClusterPath, new String[0]), new LinkOption[0])) {
            return;
        }
        Cluster cluster = EventUtil.getCluster((String)localClusterPath);
        String workingDir = clusterDir + File.separator + "working_dir";
        cluster.setWorkingDir(new WorkingDir(workingDir, true));
        cluster.setIodevices(this.configureIoDevices(cluster.getIodevices(), workingDir));
        cluster.setLogDir(this.configureDirectory(cluster.getLogDir(), workingDir));
        cluster.setTxnLogDir(this.configureDirectory(cluster.getTxnLogDir(), workingDir));
        String javaHome = System.getProperty("java.home");
        if (javaHome.endsWith(File.separator + "jre")) {
            javaHome = javaHome.substring(0, javaHome.indexOf(File.separator + "jre"));
        }
        cluster.setJavaHome(javaHome);
        for (Node node : cluster.getNode()) {
            node.setIodevices(this.configureIoDevices(node.getIodevices(), workingDir));
            node.setLogDir(this.configureDirectory(node.getLogDir(), workingDir));
            node.setTxnLogDir(this.configureDirectory(node.getTxnLogDir(), workingDir));
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Cluster.class});
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cluster, (OutputStream)new FileOutputStream(localClusterPath));
    }

    private String configureIoDevices(String ioDevices, String workingDir) {
        if (ioDevices == null) {
            return null;
        }
        String separator = ",";
        StringBuilder sb = new StringBuilder();
        String[] ioDevs = ioDevices.split(",");
        for (int i = 0; i < ioDevs.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.configureDirectory(ioDevs[i], workingDir));
        }
        return sb.toString();
    }

    private String configureDirectory(String dir, String workingDir) {
        return dir == null ? null : dir.replace(WORK_DIR, workingDir);
    }

    @Override
    protected String getUsageDescription() {
        return "\nAuto-generates the ASTERIX installer configruation settings and ASTERIX cluster \nconfiguration settings for a single node setup.";
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new ConfigureConfig();
    }
}

