/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.util.Date;
import java.util.List;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.model.BackupInfo;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.BackupConfig;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.driver.InstallerDriver;
import org.apache.asterix.installer.schema.conf.Backup;

public class BackupCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        String asterixInstanceName = ((BackupConfig)this.config).name;
        AsterixInstance instance = AsterixEventServiceUtil.validateAsterixInstanceExists((String)asterixInstanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.INACTIVE});
        List backupInfo = instance.getBackupInfo();
        Backup backupConf = AsterixEventService.getConfiguration().getBackup();
        Patterns patterns = PatternCreator.INSTANCE.getBackUpAsterixPattern(instance, backupConf);
        AsterixEventService.getAsterixEventServiceClient((Cluster)instance.getCluster()).submit(patterns);
        int backupId = backupInfo.size();
        BackupInfo binfo = new BackupInfo(backupId, new Date(), backupConf);
        backupInfo.add(binfo);
        LOGGER.info((Object)(asterixInstanceName + " backed up " + binfo));
        ServiceProvider.INSTANCE.getLookupService().updateAsterixInstance(instance);
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new BackupConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "\nThe backup command allows you to take a\nbackup of the data stored with an ASTERIX instance. \nThe backed up snapshot is stored either in HDFS or on the local file system of each node in the ASTERIX cluster.\nThe target location of backup can be configured in $MANAGIX_HOME/conf/managix-conf.xml\n\nAvailable arguments/options:\n-n name of the Asterix instance";
    }
}

