/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.job.IJobSerializerDeserializerContainer;
import org.apache.hyracks.control.common.base.IClusterController;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.deployment.DeploymentStatus;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;

public class UnDeployBinaryWork
extends AbstractWork {
    private DeploymentId deploymentId;
    private NodeControllerService ncs;

    public UnDeployBinaryWork(NodeControllerService ncs, DeploymentId deploymentId) {
        this.deploymentId = deploymentId;
        this.ncs = ncs;
    }

    public void run() {
        DeploymentStatus status;
        try {
            DeploymentUtils.undeploy((DeploymentId)this.deploymentId, (IJobSerializerDeserializerContainer)this.ncs.getContext().getJobSerializerDeserializerContainer(), (ServerContext)this.ncs.getServerContext());
            status = DeploymentStatus.SUCCEED;
        }
        catch (Exception e) {
            status = DeploymentStatus.FAIL;
        }
        try {
            IClusterController ccs = this.ncs.getClusterController();
            ccs.notifyDeployBinary(this.deploymentId, this.ncs.getId(), status);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

