/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.channels.IInputChannel;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.IPartitionCollector;
import org.apache.hyracks.api.comm.IPartitionWriterFactory;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.comm.PartitionChannel;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicy;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.comm.channels.IChannelConnectionFactory;
import org.apache.hyracks.comm.channels.NetworkInputChannel;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.hyracks.control.common.job.TaskAttemptDescriptor;
import org.apache.hyracks.control.common.utils.ExceptionUtils;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;
import org.apache.hyracks.control.nc.application.NCServiceContext;
import org.apache.hyracks.control.nc.partitions.MaterializedPartitionWriter;
import org.apache.hyracks.control.nc.partitions.MaterializingPipelinedPartition;
import org.apache.hyracks.control.nc.partitions.PipelinedPartition;
import org.apache.hyracks.control.nc.partitions.ReceiveSideMaterializingCollector;
import org.apache.hyracks.control.nc.profiling.ProfilingPartitionWriterFactory;
import org.apache.hyracks.control.nc.work.NotifyTaskFailureWork;

public class StartTasksWork
extends AbstractWork {
    private static final Logger LOGGER = Logger.getLogger(StartTasksWork.class.getName());
    private final NodeControllerService ncs;
    private final DeploymentId deploymentId;
    private final JobId jobId;
    private final byte[] acgBytes;
    private final List<TaskAttemptDescriptor> taskDescriptors;
    private final Map<ConnectorDescriptorId, IConnectorPolicy> connectorPoliciesMap;
    private final Set<JobFlag> flags;

    public StartTasksWork(NodeControllerService ncs, DeploymentId deploymentId, JobId jobId, byte[] acgBytes, List<TaskAttemptDescriptor> taskDescriptors, Map<ConnectorDescriptorId, IConnectorPolicy> connectorPoliciesMap, Set<JobFlag> flags) {
        this.ncs = ncs;
        this.deploymentId = deploymentId;
        this.jobId = jobId;
        this.acgBytes = acgBytes;
        this.taskDescriptors = taskDescriptors;
        this.connectorPoliciesMap = connectorPoliciesMap;
        this.flags = flags;
    }

    public void run() {
        Task task = null;
        try {
            NCServiceContext serviceCtx = this.ncs.getContext();
            Joblet joblet = this.getOrCreateLocalJoblet(this.deploymentId, this.jobId, serviceCtx, this.acgBytes);
            final ActivityClusterGraph acg = joblet.getActivityClusterGraph();
            IRecordDescriptorProvider rdp = new IRecordDescriptorProvider(){

                public RecordDescriptor getOutputRecordDescriptor(ActivityId aid, int outputIndex) {
                    ActivityCluster ac = (ActivityCluster)acg.getActivityMap().get(aid);
                    IConnectorDescriptor conn = (IConnectorDescriptor)((List)ac.getActivityOutputMap().get(aid)).get(outputIndex);
                    return (RecordDescriptor)ac.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                }

                public RecordDescriptor getInputRecordDescriptor(ActivityId aid, int inputIndex) {
                    ActivityCluster ac = (ActivityCluster)acg.getActivityMap().get(aid);
                    IConnectorDescriptor conn = (IConnectorDescriptor)((List)ac.getActivityInputMap().get(aid)).get(inputIndex);
                    return (RecordDescriptor)ac.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                }
            };
            for (TaskAttemptDescriptor td : this.taskDescriptors) {
                List outputs;
                RecordDescriptor recordDesc;
                TaskAttemptId taId = td.getTaskAttemptId();
                TaskId tid = taId.getTaskId();
                ActivityId aid = tid.getActivityId();
                ActivityCluster ac = (ActivityCluster)acg.getActivityMap().get(aid);
                IActivity han = (IActivity)ac.getActivityMap().get(aid);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Initializing " + taId + " -> " + han);
                }
                int partition = tid.getPartition();
                List inputs = (List)ac.getActivityInputMap().get(aid);
                task = new Task(joblet, taId, han.getClass().getName(), this.ncs.getExecutor(), this.ncs, this.createInputChannels(td, inputs));
                IOperatorNodePushable operator = han.createPushRuntime((IHyracksTaskContext)task, rdp, partition, td.getPartitionCount());
                ArrayList<IPartitionCollector> collectors = new ArrayList<IPartitionCollector>();
                if (inputs != null) {
                    for (int i = 0; i < inputs.size(); ++i) {
                        IConnectorDescriptor conn = (IConnectorDescriptor)inputs.get(i);
                        IConnectorPolicy cPolicy = this.connectorPoliciesMap.get(conn.getConnectorId());
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("input: " + i + ": " + conn.getConnectorId());
                        }
                        recordDesc = (RecordDescriptor)ac.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                        IPartitionCollector collector = this.createPartitionCollector(td, partition, task, i, conn, recordDesc, cPolicy);
                        collectors.add(collector);
                    }
                }
                if ((outputs = (List)ac.getActivityOutputMap().get(aid)) != null) {
                    for (int i = 0; i < outputs.size(); ++i) {
                        IConnectorDescriptor conn = (IConnectorDescriptor)outputs.get(i);
                        recordDesc = (RecordDescriptor)ac.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                        IConnectorPolicy cPolicy = this.connectorPoliciesMap.get(conn.getConnectorId());
                        IPartitionWriterFactory pwFactory = this.createPartitionWriterFactory(task, cPolicy, this.jobId, conn, partition, taId, this.flags);
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("output: " + i + ": " + conn.getConnectorId());
                        }
                        IFrameWriter writer = conn.createPartitioner((IHyracksTaskContext)task, recordDesc, pwFactory, partition, td.getPartitionCount(), td.getOutputPartitionCounts()[i]);
                        operator.setOutputFrameWriter(i, writer, recordDesc);
                    }
                }
                task.setTaskRuntime(collectors.toArray(new IPartitionCollector[collectors.size()]), operator);
                joblet.addTask(task);
                task.start();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failure starting a task", e);
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            ExceptionUtils.setNodeIds(exceptions, (String)this.ncs.getId());
            this.ncs.getWorkQueue().schedule((AbstractWork)new NotifyTaskFailureWork(this.ncs, task, exceptions));
        }
    }

    private Joblet getOrCreateLocalJoblet(DeploymentId deploymentId, JobId jobId, INCServiceContext appCtx, byte[] acgBytes) throws HyracksException {
        Map<JobId, Joblet> jobletMap = this.ncs.getJobletMap();
        Joblet ji = jobletMap.get(jobId);
        if (ji == null) {
            ActivityClusterGraph acg = this.ncs.getActivityClusterGraph(jobId);
            if (acg == null) {
                if (acgBytes == null) {
                    throw HyracksException.create((int)21, (Serializable[])new Serializable[]{jobId});
                }
                acg = (ActivityClusterGraph)DeploymentUtils.deserialize((byte[])acgBytes, (DeploymentId)deploymentId, (IServiceContext)appCtx);
            }
            ji = new Joblet(this.ncs, deploymentId, jobId, appCtx, acg);
            jobletMap.put(jobId, ji);
        }
        return ji;
    }

    private IPartitionCollector createPartitionCollector(TaskAttemptDescriptor td, int partition, Task task, int i, IConnectorDescriptor conn, RecordDescriptor recordDesc, IConnectorPolicy cPolicy) throws HyracksDataException {
        IPartitionCollector collector = conn.createPartitionCollector((IHyracksTaskContext)task, recordDesc, partition, td.getInputPartitionCounts()[i], td.getPartitionCount());
        if (cPolicy.materializeOnReceiveSide()) {
            return new ReceiveSideMaterializingCollector(task, this.ncs.getPartitionManager(), collector, task.getTaskAttemptId(), this.ncs.getExecutor());
        }
        return collector;
    }

    private IPartitionWriterFactory createPartitionWriterFactory(final IHyracksTaskContext ctx, IConnectorPolicy cPolicy, final JobId jobId, final IConnectorDescriptor conn, final int senderIndex, final TaskAttemptId taId, Set<JobFlag> flags) {
        Object factory = cPolicy.materializeOnSendSide() ? (cPolicy.consumerWaitsForProducerToFinish() ? new IPartitionWriterFactory(){

            public IFrameWriter createFrameWriter(int receiverIndex) throws HyracksDataException {
                return new MaterializedPartitionWriter(ctx, StartTasksWork.this.ncs.getPartitionManager(), new PartitionId(jobId, conn.getConnectorId(), senderIndex, receiverIndex), taId, StartTasksWork.this.ncs.getExecutor());
            }
        } : new IPartitionWriterFactory(){

            public IFrameWriter createFrameWriter(int receiverIndex) throws HyracksDataException {
                return new MaterializingPipelinedPartition(ctx, StartTasksWork.this.ncs.getPartitionManager(), new PartitionId(jobId, conn.getConnectorId(), senderIndex, receiverIndex), taId, StartTasksWork.this.ncs.getExecutor());
            }
        }) : new IPartitionWriterFactory(){

            public IFrameWriter createFrameWriter(int receiverIndex) throws HyracksDataException {
                return new PipelinedPartition(ctx, StartTasksWork.this.ncs.getPartitionManager(), new PartitionId(jobId, conn.getConnectorId(), senderIndex, receiverIndex), taId);
            }
        };
        if (flags.contains(JobFlag.PROFILE_RUNTIME)) {
            factory = new ProfilingPartitionWriterFactory(ctx, conn, senderIndex, (IPartitionWriterFactory)factory);
        }
        return factory;
    }

    private List<List<PartitionChannel>> createInputChannels(TaskAttemptDescriptor td, List<IConnectorDescriptor> inputs) throws UnknownHostException {
        NetworkAddress[][] inputAddresses = td.getInputPartitionLocations();
        ArrayList<List<PartitionChannel>> channelsForInputConnectors = new ArrayList<List<PartitionChannel>>();
        if (inputAddresses != null) {
            for (int i = 0; i < inputAddresses.length; ++i) {
                ArrayList<PartitionChannel> channels = new ArrayList<PartitionChannel>();
                if (inputAddresses[i] != null) {
                    for (int j = 0; j < inputAddresses[i].length; ++j) {
                        NetworkAddress networkAddress = inputAddresses[i][j];
                        PartitionId pid = new PartitionId(this.jobId, inputs.get(i).getConnectorId(), j, td.getTaskAttemptId().getTaskId().getPartition());
                        PartitionChannel channel = new PartitionChannel(pid, (IInputChannel)new NetworkInputChannel((IChannelConnectionFactory)this.ncs.getNetworkManager(), (SocketAddress)new InetSocketAddress(InetAddress.getByAddress(networkAddress.lookupIpAddress()), networkAddress.getPort()), pid, 5));
                        channels.add(channel);
                    }
                }
                channelsForInputConnectors.add(channels);
            }
        }
        return channelsForInputConnectors;
    }
}

