/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.List;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;

public class NotifyTaskFailureWork
extends AbstractWork {
    private final NodeControllerService ncs;
    private final Task task;
    private final List<Exception> exceptions;

    public NotifyTaskFailureWork(NodeControllerService ncs, Task task, List<Exception> exceptions) {
        this.ncs = ncs;
        this.task = task;
        this.exceptions = exceptions;
    }

    public void run() {
        try {
            JobId jobId = this.task.getJobletContext().getJobId();
            IDatasetPartitionManager dpm = this.ncs.getDatasetPartitionManager();
            if (dpm != null) {
                dpm.abortReader(jobId);
            }
            this.ncs.getClusterController().notifyTaskFailure(jobId, this.task.getTaskAttemptId(), this.ncs.getId(), this.exceptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.task.getJoblet().removeTask(this.task);
    }
}

