/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.control.common.base.IClusterController;
import org.apache.hyracks.control.nc.NodeControllerService;

public class ShutdownTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ShutdownTask.class.getName());
    private final NodeControllerService ncs;
    private final boolean terminateNCService;

    public ShutdownTask(NodeControllerService ncs, boolean terminateNCService) {
        this.ncs = ncs;
        this.terminateNCService = terminateNCService;
    }

    @Override
    public void run() {
        IClusterController ccs = this.ncs.getClusterController();
        try {
            ccs.notifyShutdown(this.ncs.getId());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception notifying CC of shutdown acknowledgment", e);
        }
        LOGGER.info("JVM Exiting.. Bye!");
        Thread t = new Thread("NC " + this.ncs.getId() + " Shutdown"){

            @Override
            public void run() {
                try {
                    ShutdownTask.this.ncs.stop();
                }
                catch (Exception e) {
                    try {
                        LOGGER.log(Level.SEVERE, "Exception stopping node controller service", e);
                    }
                    catch (Throwable throwable) {
                        Runtime rt = Runtime.getRuntime();
                        rt.exit(ShutdownTask.this.terminateNCService ? 99 : 0);
                        throw throwable;
                    }
                    Runtime rt = Runtime.getRuntime();
                    rt.exit(ShutdownTask.this.terminateNCService ? 99 : 0);
                }
                Runtime rt = Runtime.getRuntime();
                rt.exit(ShutdownTask.this.terminateNCService ? 99 : 0);
            }
        };
        t.start();
    }
}

