/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;

public class FileHandle
implements IFileHandle {
    private final FileReference fileRef;
    private RandomAccessFile raf;
    private FileChannel channel;

    public FileHandle(FileReference fileRef) {
        this.fileRef = fileRef;
    }

    public void open(IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws IOException {
        String mode;
        block0 : switch (rwMode) {
            case READ_ONLY: {
                mode = "r";
                break;
            }
            case READ_WRITE: {
                this.fileRef.getFile().getAbsoluteFile().getParentFile().mkdirs();
                switch (syncMode) {
                    case METADATA_ASYNC_DATA_ASYNC: {
                        mode = "rw";
                        break block0;
                    }
                    case METADATA_ASYNC_DATA_SYNC: {
                        mode = "rwd";
                        break block0;
                    }
                    case METADATA_SYNC_DATA_SYNC: {
                        mode = "rws";
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.raf = new RandomAccessFile(this.fileRef.getFile(), mode);
    }

    public void close() throws IOException {
        if (this.raf == null) {
            return;
        }
        this.raf.close();
        this.raf = null;
    }

    public FileReference getFileReference() {
        return this.fileRef;
    }

    public FileChannel getFileChannel() {
        if (this.channel == null) {
            this.channel = this.raf.getChannel();
        }
        return this.channel;
    }
}

