/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.dataset;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataset.IDatasetStateRecord;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.nc.dataset.DatasetPartitionManager;
import org.apache.hyracks.control.nc.dataset.ResultState;

class ResultSetMap
implements IDatasetStateRecord,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DatasetPartitionManager.class.getName());
    private final long timestamp = System.currentTimeMillis();
    private final HashMap<ResultSetId, ResultState[]> resultStateMap = new HashMap();

    ResultSetMap() {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    ResultState[] getResultStates(ResultSetId rsId) {
        return this.resultStateMap.get(rsId);
    }

    ResultState[] createOrGetResultStates(ResultSetId rsId, int nPartitions) {
        return this.resultStateMap.computeIfAbsent(rsId, k -> new ResultState[nPartitions]);
    }

    boolean removePartition(JobId jobId, ResultSetId resultSetId, int partition) {
        ResultState[] resultStates = this.resultStateMap.get(resultSetId);
        if (resultStates != null) {
            ResultState state = resultStates[partition];
            if (state != null) {
                state.closeAndDelete();
                LOGGER.fine("Removing partition: " + partition + " for JobId: " + jobId);
            }
            resultStates[partition] = null;
            boolean stateEmpty = true;
            for (ResultState resState : resultStates) {
                if (resState == null) continue;
                stateEmpty = false;
                break;
            }
            if (stateEmpty) {
                this.resultStateMap.remove(resultSetId);
            }
            return this.resultStateMap.isEmpty();
        }
        return true;
    }

    void abortAll() {
        this.applyToAllStates((rsId, state, i) -> state.abort());
    }

    void closeAndDeleteAll() {
        this.applyToAllStates((rsId, state, i) -> {
            state.closeAndDelete();
            LOGGER.fine("Removing partition: " + i + " for result set " + rsId);
        });
    }

    private void applyToAllStates(StateModifier modifier) {
        for (Map.Entry<ResultSetId, ResultState[]> entry : this.resultStateMap.entrySet()) {
            ResultSetId rsId = entry.getKey();
            ResultState[] resultStates = entry.getValue();
            if (resultStates == null) continue;
            for (int i = 0; i < resultStates.length; ++i) {
                ResultState state = resultStates[i];
                if (state == null) continue;
                modifier.modify(rsId, state, i);
            }
        }
    }

    @FunctionalInterface
    private static interface StateModifier {
        public void modify(ResultSetId var1, ResultState var2, int var3);
    }
}

