/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.dataset;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.partitions.ResultSetPartitionId;
import org.apache.hyracks.control.nc.dataset.DatasetMemoryManager;
import org.apache.hyracks.control.nc.dataset.ResultState;

public class DatasetPartitionWriter
implements IFrameWriter {
    private static final Logger LOGGER = Logger.getLogger(DatasetPartitionWriter.class.getName());
    private final IDatasetPartitionManager manager;
    private final JobId jobId;
    private final ResultSetId resultSetId;
    private final boolean orderedResult;
    private final int partition;
    private final int nPartitions;
    private final DatasetMemoryManager datasetMemoryManager;
    private final ResultSetPartitionId resultSetPartitionId;
    private final ResultState resultState;
    private boolean partitionRegistered;
    private boolean failed = false;

    public DatasetPartitionWriter(IHyracksTaskContext ctx, IDatasetPartitionManager manager, JobId jobId, ResultSetId rsId, boolean asyncMode, boolean orderedResult, int partition, int nPartitions, DatasetMemoryManager datasetMemoryManager, IWorkspaceFileFactory fileFactory) {
        this.manager = manager;
        this.jobId = jobId;
        this.resultSetId = rsId;
        this.orderedResult = orderedResult;
        this.partition = partition;
        this.nPartitions = nPartitions;
        this.datasetMemoryManager = datasetMemoryManager;
        this.resultSetPartitionId = new ResultSetPartitionId(jobId, rsId, partition);
        this.resultState = new ResultState(this.resultSetPartitionId, asyncMode, ctx.getIOManager(), fileFactory, ctx.getInitialFrameSize());
    }

    public ResultState getResultState() {
        return this.resultState;
    }

    public void open() {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("open(" + this.partition + ")");
        }
        this.partitionRegistered = false;
        this.resultState.open();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.registerResultPartitionLocation(false);
        if (this.datasetMemoryManager == null) {
            this.resultState.write(buffer);
        } else {
            this.resultState.write(this.datasetMemoryManager, buffer);
        }
    }

    public void fail() throws HyracksDataException {
        try {
            this.failed = true;
            this.resultState.closeAndDelete();
            this.resultState.abort();
            this.registerResultPartitionLocation(false);
            this.manager.reportPartitionFailure(this.jobId, this.resultSetId, this.partition);
        }
        catch (HyracksException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void close() throws HyracksDataException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("close(" + this.partition + ")");
        }
        try {
            if (!this.failed) {
                this.registerResultPartitionLocation(true);
            }
        }
        finally {
            this.resultState.close();
        }
        try {
            this.manager.reportPartitionWriteCompletion(this.jobId, this.resultSetId, this.partition);
        }
        catch (HyracksException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    void registerResultPartitionLocation(boolean empty) throws HyracksDataException {
        try {
            if (!this.partitionRegistered) {
                this.manager.registerResultPartitionLocation(this.jobId, this.resultSetId, this.partition, this.nPartitions, this.orderedResult, empty);
                this.partitionRegistered = true;
            }
        }
        catch (HyracksException e) {
            if (e instanceof HyracksDataException) {
                throw (HyracksDataException)e;
            }
            throw new HyracksDataException((Throwable)e);
        }
    }
}

