/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.IPartitionCollector;
import org.apache.hyracks.api.comm.PartitionChannel;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.job.IOperatorEnvironment;
import org.apache.hyracks.api.job.profiling.counters.ICounter;
import org.apache.hyracks.api.job.profiling.counters.ICounterContext;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.api.resources.IDeallocatableRegistry;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.hyracks.control.common.job.profiling.counters.Counter;
import org.apache.hyracks.control.common.job.profiling.om.PartitionProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.hyracks.control.common.utils.ExceptionUtils;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.io.WorkspaceFileFactory;
import org.apache.hyracks.control.nc.resources.DefaultDeallocatableRegistry;
import org.apache.hyracks.control.nc.work.NotifyTaskCompleteWork;
import org.apache.hyracks.control.nc.work.NotifyTaskFailureWork;

public class Task
implements IHyracksTaskContext,
ICounterContext,
Runnable {
    private final Joblet joblet;
    private final TaskAttemptId taskAttemptId;
    private final String displayName;
    private final ExecutorService executorService;
    private final IWorkspaceFileFactory fileFactory;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final Map<String, Counter> counterMap;
    private final IOperatorEnvironment opEnv;
    private final Map<PartitionId, PartitionProfile> partitionSendProfile;
    private final Set<Thread> pendingThreads;
    private IPartitionCollector[] collectors;
    private IOperatorNodePushable operator;
    private final List<Exception> exceptions;
    private volatile boolean aborted;
    private NodeControllerService ncs;
    private List<List<PartitionChannel>> inputChannelsFromConnectors;
    private Object sharedObject;

    public Task(Joblet joblet, TaskAttemptId taskId, String displayName, ExecutorService executor, NodeControllerService ncs, List<List<PartitionChannel>> inputChannelsFromConnectors) {
        this.joblet = joblet;
        this.taskAttemptId = taskId;
        this.displayName = displayName;
        this.executorService = executor;
        this.fileFactory = new WorkspaceFileFactory((IDeallocatableRegistry)this, joblet.getIOManager());
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.counterMap = new HashMap<String, Counter>();
        this.opEnv = joblet.getEnvironment();
        this.partitionSendProfile = new Hashtable<PartitionId, PartitionProfile>();
        this.pendingThreads = new LinkedHashSet<Thread>();
        this.exceptions = new ArrayList<Exception>();
        this.ncs = ncs;
        this.inputChannelsFromConnectors = inputChannelsFromConnectors;
    }

    public void setTaskRuntime(IPartitionCollector[] collectors, IOperatorNodePushable operator) {
        this.collectors = collectors;
        this.operator = operator;
    }

    public ByteBuffer allocateFrame() throws HyracksDataException {
        return this.joblet.allocateFrame();
    }

    public ByteBuffer allocateFrame(int bytes) throws HyracksDataException {
        return this.joblet.allocateFrame(bytes);
    }

    public ByteBuffer reallocateFrame(ByteBuffer usedBuffer, int newSizeInBytes, boolean copyOldData) throws HyracksDataException {
        return this.joblet.reallocateFrame(usedBuffer, newSizeInBytes, copyOldData);
    }

    public void deallocateFrames(int bytes) {
        this.joblet.deallocateFrames(bytes);
    }

    public int getInitialFrameSize() {
        return this.joblet.getFrameSize();
    }

    public IIOManager getIOManager() {
        return this.joblet.getIOManager();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public FileReference createUnmanagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createUnmanagedWorkspaceFile(prefix);
    }

    public FileReference createManagedWorkspaceFile(String prefix) throws HyracksDataException {
        return this.fileFactory.createManagedWorkspaceFile(prefix);
    }

    public void registerDeallocatable(IDeallocatable deallocatable) {
        this.deallocatableRegistry.registerDeallocatable(deallocatable);
    }

    public void close() {
        this.deallocatableRegistry.close();
    }

    public IHyracksJobletContext getJobletContext() {
        return this.joblet;
    }

    public TaskAttemptId getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public ICounter getCounter(String name, boolean create) {
        Counter counter = this.counterMap.get(name);
        if (counter == null && create) {
            counter = new Counter(name);
            this.counterMap.put(name, counter);
        }
        return counter;
    }

    public ICounterContext getCounterContext() {
        return this;
    }

    public Joblet getJoblet() {
        return this.joblet;
    }

    public Map<PartitionId, PartitionProfile> getPartitionSendProfile() {
        return this.partitionSendProfile;
    }

    public synchronized void dumpProfile(TaskProfile tProfile) {
        Map dumpMap = tProfile.getCounters();
        for (Counter c : this.counterMap.values()) {
            dumpMap.put(c.getName(), c.get());
        }
    }

    public void setPartitionSendProfile(PartitionProfile profile) {
        this.partitionSendProfile.put(profile.getPartitionId(), profile);
    }

    public void start() throws HyracksException {
        this.aborted = false;
        this.executorService.execute(this);
    }

    public synchronized void abort() {
        this.aborted = true;
        for (IPartitionCollector c : this.collectors) {
            c.abort();
        }
        for (Thread t : this.pendingThreads) {
            t.interrupt();
        }
    }

    private synchronized boolean addPendingThread(Thread t) {
        if (this.aborted) {
            return false;
        }
        this.pendingThreads.add(t);
        return true;
    }

    private synchronized void removePendingThread(Thread t) {
        this.pendingThreads.remove(t);
        if (this.pendingThreads.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized void waitForCompletion() throws InterruptedException {
        while (!this.pendingThreads.isEmpty()) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NodeControllerService ncs;
        Thread ct = Thread.currentThread();
        String threadName = ct.getName();
        if (!this.addPendingThread(ct)) {
            this.exceptions.add(new InterruptedException("Task " + this.getTaskAttemptId() + " was aborted!"));
            ExceptionUtils.setNodeIds(this.exceptions, (String)this.ncs.getId());
            this.ncs.getWorkQueue().schedule((AbstractWork)new NotifyTaskFailureWork(this.ncs, this, this.exceptions));
            return;
        }
        ct.setName(this.displayName + ":" + this.taskAttemptId + ":" + 0);
        try {
            block15: {
                try {
                    this.operator.initialize();
                    if (this.collectors.length <= 0) break block15;
                    final Semaphore sem = new Semaphore(this.collectors.length - 1);
                    int i = 1;
                    while (i < this.collectors.length) {
                        final IPartitionCollector collector = this.collectors[i];
                        final IFrameWriter writer = this.operator.getInputFrameWriter(i);
                        sem.acquire();
                        final int cIdx = i++;
                        this.executorService.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Thread thread = Thread.currentThread();
                                if (!Task.this.addPendingThread(thread)) {
                                    return;
                                }
                                String oldName = thread.getName();
                                thread.setName(Task.this.displayName + ":" + Task.this.taskAttemptId + ":" + cIdx);
                                thread.setPriority(1);
                                try {
                                    Task.this.pushFrames(collector, (List)Task.this.inputChannelsFromConnectors.get(cIdx), writer);
                                }
                                catch (HyracksDataException e) {
                                    Task task = Task.this;
                                    synchronized (task) {
                                        Task.this.exceptions.add(e);
                                    }
                                }
                                finally {
                                    thread.setName(oldName);
                                    sem.release();
                                    Task.this.removePendingThread(thread);
                                }
                            }
                        });
                    }
                    try {
                        this.pushFrames(this.collectors[0], this.inputChannelsFromConnectors.get(0), this.operator.getInputFrameWriter(0));
                    }
                    finally {
                        sem.acquire(this.collectors.length - 1);
                    }
                }
                finally {
                    this.operator.deinitialize();
                }
            }
            ncs = this.joblet.getNodeController();
            ncs.getWorkQueue().schedule((AbstractWork)new NotifyTaskCompleteWork(ncs, this));
        }
        catch (Exception e) {
            this.exceptions.add(e);
        }
        finally {
            ct.setName(threadName);
            this.close();
            this.removePendingThread(ct);
        }
        if (!this.exceptions.isEmpty()) {
            for (Exception e : this.exceptions) {
                e.printStackTrace();
            }
            ncs = this.joblet.getNodeController();
            ExceptionUtils.setNodeIds(this.exceptions, (String)ncs.getId());
            ncs.getWorkQueue().schedule((AbstractWork)new NotifyTaskFailureWork(ncs, this, this.exceptions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushFrames(IPartitionCollector collector, List<PartitionChannel> inputChannels, IFrameWriter writer) throws HyracksDataException {
        if (this.aborted) {
            return;
        }
        try {
            collector.open();
            try {
                if (inputChannels.size() <= 0) {
                    this.joblet.advertisePartitionRequest(this.taskAttemptId, collector.getRequiredPartitionIds(), collector, PartitionState.STARTED);
                } else {
                    collector.addPartitions(inputChannels);
                }
                reader.open();
                try (IFrameReader reader = collector.getReader();){
                    writer.open();
                    try {
                        VSizeFrame frame = new VSizeFrame((IHyracksFrameMgrContext)this);
                        while (true) {
                            if (reader.nextFrame((IFrame)frame)) {
                                if (this.aborted) {
                                    return;
                                }
                                ByteBuffer buffer = frame.getBuffer();
                                writer.nextFrame(buffer);
                                buffer.compact();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        writer.fail();
                        throw e;
                    }
                    finally {
                        writer.close();
                    }
                }
            }
            finally {
                collector.close();
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void setStateObject(IStateObject taskState) {
        this.opEnv.setStateObject(taskState);
    }

    public IStateObject getStateObject(Object id) {
        return this.opEnv.getStateObject(id);
    }

    public IDatasetPartitionManager getDatasetPartitionManager() {
        return this.ncs.getDatasetPartitionManager();
    }

    public void sendApplicationMessageToCC(byte[] message, DeploymentId deploymentId) throws Exception {
        this.ncs.sendApplicationMessageToCC(message, deploymentId);
    }

    public void sendApplicationMessageToCC(Serializable message, DeploymentId deploymentId) throws Exception {
        this.ncs.sendApplicationMessageToCC(JavaSerializationUtils.serialize((Serializable)message), deploymentId);
    }

    public void setSharedObject(Object object) {
        this.sharedObject = object;
    }

    public Object getSharedObject() {
        return this.sharedObject;
    }
}

