/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.application.INCApplication;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.config.ConfigUtils;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.nc.BaseNCApplication;
import org.apache.hyracks.control.nc.NCShutdownHook;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.kohsuke.args4j.CmdLineException;

public class NCDriver {
    private static final Logger LOGGER = Logger.getLogger(NCDriver.class.getName());

    private NCDriver() {
    }

    public static void main(String[] args) {
        try {
            String nodeId = ConfigUtils.getOptionValue((String[])args, (IOption)NCConfig.Option.NODE_ID);
            ConfigManager configManager = new ConfigManager(args);
            INCApplication application = NCDriver.getApplication(args);
            application.registerConfig((IConfigManager)configManager);
            NCConfig ncConfig = new NCConfig(nodeId, configManager);
            NodeControllerService ncService = new NodeControllerService(ncConfig, application);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Setting uncaught exception handler " + ncService.getLifeCycleComponentManager());
            }
            Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)ncService.getLifeCycleComponentManager());
            ncService.start();
            Runtime.getRuntime().addShutdownHook(new NCShutdownHook(ncService));
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (CmdLineException e) {
            LOGGER.log(Level.FINE, "Exception parsing command line: " + Arrays.toString(args), e);
            System.exit(2);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exiting NCDriver due to exception", e);
            System.exit(1);
        }
    }

    private static INCApplication getApplication(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        String appClassName = ConfigUtils.getOptionValue((String[])args, (IOption)NCConfig.Option.APP_CLASS);
        return appClassName != null ? (INCApplication)Class.forName(appClassName).newInstance() : BaseNCApplication.INSTANCE;
    }
}

