/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTreeCursorInitialState;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class BTreeRangeSearchCursor
implements ITreeIndexCursor {
    private final IBTreeLeafFrame frame;
    private final ITreeIndexTupleReference frameTuple;
    private final boolean exclusiveLatchNodes;
    private boolean isPageDirty;
    private IBufferCache bufferCache = null;
    private int fileId = -1;
    private ICachedPage page = null;
    private int pageId = -1;
    private int tupleIndex = 0;
    private int stopTupleIndex;
    private final RangePredicate reusablePredicate;
    private final ArrayTupleReference reconciliationTuple;
    private IIndexAccessor accessor;
    private ISearchOperationCallback searchCb;
    private MultiComparator originalKeyCmp;
    private ArrayTupleBuilder tupleBuilder;
    private FindTupleMode lowKeyFtm;
    private FindTupleMode highKeyFtm;
    private FindTupleNoExactMatchPolicy lowKeyFtp;
    private FindTupleNoExactMatchPolicy highKeyFtp;
    private RangePredicate pred;
    private MultiComparator lowKeyCmp;
    private MultiComparator highKeyCmp;
    protected ITupleReference lowKey;
    private ITupleReference highKey;

    public BTreeRangeSearchCursor(IBTreeLeafFrame frame, boolean exclusiveLatchNodes) {
        this.frame = frame;
        this.frameTuple = frame.createTupleReference();
        this.exclusiveLatchNodes = exclusiveLatchNodes;
        this.reusablePredicate = new RangePredicate();
        this.reconciliationTuple = new ArrayTupleReference();
    }

    public void close() throws HyracksDataException {
        if (this.page != null) {
            if (this.exclusiveLatchNodes) {
                this.page.releaseWriteLatch(this.isPageDirty);
            } else {
                this.page.releaseReadLatch();
            }
            this.bufferCache.unpin(this.page);
        }
        this.tupleIndex = 0;
        this.page = null;
        this.isPageDirty = false;
        this.pred = null;
    }

    public ITupleReference getTuple() {
        return this.frameTuple;
    }

    public ICachedPage getPage() {
        return this.page;
    }

    public int getTupleOffset() {
        return this.frame.getTupleOffset(this.tupleIndex - 1);
    }

    public int getPageId() {
        return this.pageId;
    }

    private void fetchNextLeafPage(int nextLeafPage) throws HyracksDataException {
        do {
            ICachedPage nextLeaf = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)nextLeafPage), false);
            if (this.exclusiveLatchNodes) {
                nextLeaf.acquireWriteLatch();
                this.page.releaseWriteLatch(this.isPageDirty);
            } else {
                nextLeaf.acquireReadLatch();
                this.page.releaseReadLatch();
            }
            this.bufferCache.unpin(this.page);
            this.page = nextLeaf;
            this.isPageDirty = false;
            this.frame.setPage(this.page);
            this.pageId = nextLeafPage;
            nextLeafPage = this.frame.getNextLeaf();
        } while (this.frame.getTupleCount() == 0 && nextLeafPage > 0);
    }

    public boolean hasNext() throws HyracksDataException {
        if (this.tupleIndex >= this.frame.getTupleCount()) {
            int nextLeafPage = this.frame.getNextLeaf();
            if (nextLeafPage >= 0) {
                this.fetchNextLeafPage(nextLeafPage);
                this.tupleIndex = 0;
                this.stopTupleIndex = this.getHighKeyIndex();
                if (this.stopTupleIndex < 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.tupleIndex > this.stopTupleIndex) {
            return false;
        }
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, this.tupleIndex);
        while (!this.searchCb.proceed((ITupleReference)this.frameTuple)) {
            if (this.tupleBuilder == null) {
                this.tupleBuilder = new ArrayTupleBuilder(this.originalKeyCmp.getKeyFieldCount());
            }
            TupleUtils.copyTuple((ArrayTupleBuilder)this.tupleBuilder, (ITupleReference)this.frameTuple, (int)this.originalKeyCmp.getKeyFieldCount());
            this.reconciliationTuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
            if (this.exclusiveLatchNodes) {
                this.page.releaseWriteLatch(this.isPageDirty);
            } else {
                this.page.releaseReadLatch();
            }
            this.bufferCache.unpin(this.page);
            this.page = null;
            this.isPageDirty = false;
            this.searchCb.reconcile((ITupleReference)this.reconciliationTuple);
            this.reusablePredicate.setLowKey((ITupleReference)this.reconciliationTuple, true);
            try {
                this.accessor.search((IIndexCursor)this, (ISearchPredicate)this.reusablePredicate);
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
            if (this.stopTupleIndex < 0 || this.tupleIndex > this.stopTupleIndex) {
                return false;
            }
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this.frame, this.tupleIndex);
            if (this.originalKeyCmp.compare((ITupleReference)this.reconciliationTuple, (ITupleReference)this.frameTuple) == 0) {
                return true;
            }
            this.searchCb.cancel((ITupleReference)this.reconciliationTuple);
        }
        return true;
    }

    public void next() throws HyracksDataException {
        ++this.tupleIndex;
    }

    private int getLowKeyIndex() throws HyracksDataException {
        if (this.lowKey == null) {
            return 0;
        }
        int index = this.frame.findTupleIndex(this.lowKey, this.frameTuple, this.lowKeyCmp, this.lowKeyFtm, this.lowKeyFtp);
        if (this.pred.lowKeyInclusive) {
            ++index;
        } else if (index < 0) {
            index = this.frame.getTupleCount();
        }
        return index;
    }

    private int getHighKeyIndex() throws HyracksDataException {
        if (this.highKey == null) {
            return this.frame.getTupleCount() - 1;
        }
        int index = this.frame.findTupleIndex(this.highKey, this.frameTuple, this.highKeyCmp, this.highKeyFtm, this.highKeyFtp);
        if (this.pred.highKeyInclusive) {
            index = index < 0 ? this.frame.getTupleCount() - 1 : --index;
        }
        return index;
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        if (this.page != null) {
            if (this.exclusiveLatchNodes) {
                this.page.releaseWriteLatch(this.isPageDirty);
            } else {
                this.page.releaseReadLatch();
            }
            this.bufferCache.unpin(this.page);
        }
        this.accessor = ((BTreeCursorInitialState)initialState).getAccessor();
        this.searchCb = initialState.getSearchOperationCallback();
        this.originalKeyCmp = initialState.getOriginalKeyComparator();
        this.pageId = ((BTreeCursorInitialState)initialState).getPageId();
        this.page = initialState.getPage();
        this.isPageDirty = false;
        this.frame.setPage(this.page);
        this.pred = (RangePredicate)searchPred;
        this.lowKeyCmp = this.pred.getLowKeyComparator();
        this.highKeyCmp = this.pred.getHighKeyComparator();
        this.lowKey = this.pred.getLowKey();
        this.highKey = this.pred.getHighKey();
        this.reusablePredicate.setLowKeyComparator(this.originalKeyCmp);
        this.reusablePredicate.setHighKeyComparator(this.pred.getHighKeyComparator());
        this.reusablePredicate.setHighKey(this.pred.getHighKey(), this.pred.isHighKeyInclusive());
        this.lowKeyFtm = FindTupleMode.EXCLUSIVE;
        this.lowKeyFtp = this.pred.lowKeyInclusive ? FindTupleNoExactMatchPolicy.LOWER_KEY : FindTupleNoExactMatchPolicy.HIGHER_KEY;
        this.highKeyFtm = FindTupleMode.EXCLUSIVE;
        this.highKeyFtp = this.pred.highKeyInclusive ? FindTupleNoExactMatchPolicy.HIGHER_KEY : FindTupleNoExactMatchPolicy.LOWER_KEY;
        this.tupleIndex = this.getLowKeyIndex();
        this.stopTupleIndex = this.getHighKeyIndex();
    }

    public void reset() throws HyracksDataException {
        this.close();
    }

    public void setBufferCache(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public boolean exclusiveLatchNodes() {
        return this.exclusiveLatchNodes;
    }

    public void markCurrentTupleAsUpdated() throws HyracksDataException {
        if (!this.exclusiveLatchNodes) {
            throw new HyracksDataException("This cursor has not been created with the intention to allow updates.");
        }
        this.isPageDirty = true;
    }

    public boolean isBloomFilterAware() {
        return false;
    }
}

