/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.frames;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.frames.AbstractSlotManager;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;

public class OrderedSlotManager
extends AbstractSlotManager {
    public int findTupleIndex(ITupleReference searchKey, ITreeIndexTupleReference frameTuple, MultiComparator multiCmp, FindTupleMode mode, FindTupleNoExactMatchPolicy matchPolicy) throws HyracksDataException {
        int tupleCount = this.frame.getTupleCount();
        if (tupleCount <= 0) {
            return -1;
        }
        int end = tupleCount - 1;
        frameTuple.resetByTupleIndex(this.frame, end);
        int cmp = multiCmp.compare(searchKey, (ITupleReference)frameTuple);
        int begin = cmp > 0 ? tupleCount : 0;
        while (begin <= end) {
            int mid = (begin + end) / 2;
            frameTuple.resetByTupleIndex(this.frame, mid);
            cmp = multiCmp.compare(searchKey, (ITupleReference)frameTuple);
            if (cmp < 0) {
                end = mid - 1;
                continue;
            }
            if (cmp > 0) {
                begin = mid + 1;
                continue;
            }
            if (mode == FindTupleMode.EXCLUSIVE) {
                if (matchPolicy == FindTupleNoExactMatchPolicy.HIGHER_KEY) {
                    begin = mid + 1;
                    continue;
                }
                end = mid - 1;
                continue;
            }
            if (mode == FindTupleMode.EXCLUSIVE_ERROR_IF_EXISTS) {
                return -2;
            }
            return mid;
        }
        if (mode == FindTupleMode.EXACT) {
            return -2;
        }
        if (matchPolicy == FindTupleNoExactMatchPolicy.HIGHER_KEY) {
            if (begin > tupleCount - 1) {
                return -1;
            }
            frameTuple.resetByTupleIndex(this.frame, begin);
            if (multiCmp.compare(searchKey, (ITupleReference)frameTuple) < 0) {
                return begin;
            }
            return -1;
        }
        if (end < 0) {
            return -1;
        }
        frameTuple.resetByTupleIndex(this.frame, end);
        if (multiCmp.compare(searchKey, (ITupleReference)frameTuple) > 0) {
            return end;
        }
        return -1;
    }

    public int insertSlot(int tupleIndex, int tupleOff) {
        int slotOff = this.getSlotOff(tupleIndex);
        if (tupleIndex == -1) {
            slotOff = this.getSlotEndOff() - 4;
            this.setSlot(slotOff, tupleOff);
            return slotOff;
        }
        int slotEndOff = this.getSlotEndOff();
        int length = slotOff - slotEndOff + 4;
        System.arraycopy(this.frame.getBuffer().array(), slotEndOff, this.frame.getBuffer().array(), slotEndOff - 4, length);
        this.setSlot(slotOff, tupleOff);
        return slotOff;
    }
}

