/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.dataflow;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.TreeIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.util.IndexFileNameUtil;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class BTreeDataflowHelper
extends TreeIndexDataflowHelper {
    public BTreeDataflowHelper(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, boolean durable) throws HyracksDataException {
        super(opDesc, ctx, partition, durable);
    }

    public ITreeIndex createIndexInstance() throws HyracksDataException {
        AbstractTreeIndexOperatorDescriptor treeOpDesc = (AbstractTreeIndexOperatorDescriptor)this.opDesc;
        FileReference fileRef = IndexFileNameUtil.getIndexAbsoluteFileRef((IIndexOperatorDescriptor)treeOpDesc, (int)this.ctx.getTaskAttemptId().getTaskId().getPartition(), (IIOManager)this.ctx.getIOManager());
        IBufferCache bufferCache = this.opDesc.getStorageManager().getBufferCache(this.ctx);
        return BTreeUtils.createBTree(bufferCache, this.opDesc.getStorageManager().getFileMapProvider(this.ctx), treeOpDesc.getTreeIndexTypeTraits(), treeOpDesc.getTreeIndexComparatorFactories(), BTreeLeafFrameType.REGULAR_NSM, fileRef, this.pageManagerFactory.createPageManager(bufferCache));
    }
}

