/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.common.exceptions;

import java.io.Serializable;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.util.ErrorMessageUtil;

public class AlgebricksException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN = 0;
    private final String component;
    private final int errorCode;
    private final Serializable[] params;
    private final String nodeId;
    private volatile transient String msgCache;

    public AlgebricksException(String component, int errorCode, String message, Throwable cause, String nodeId, Serializable ... params) {
        super(message, cause);
        this.component = component;
        this.errorCode = errorCode;
        this.nodeId = nodeId;
        this.params = params;
    }

    public static AlgebricksException create(int errorCode, Serializable ... params) {
        return new AlgebricksException("HYR", errorCode, ErrorCode.getErrorMessage((int)errorCode), params);
    }

    @Deprecated
    public AlgebricksException(String message) {
        this("", 0, message, null, null);
    }

    @Deprecated
    public AlgebricksException(Throwable cause) {
        this("", 0, cause.getMessage(), cause, null);
    }

    @Deprecated
    public AlgebricksException(Throwable cause, String nodeId) {
        this("", 0, cause.getMessage(), cause, nodeId, new Serializable[0]);
    }

    @Deprecated
    public AlgebricksException(String message, Throwable cause, String nodeId) {
        this("", 0, message, cause, nodeId, new Serializable[0]);
    }

    @Deprecated
    public AlgebricksException(String message, Throwable cause) {
        this("", 0, message, cause, (String)null, new Serializable[0]);
    }

    public AlgebricksException(String component, int errorCode, Serializable ... params) {
        this(component, errorCode, (String)null, (Throwable)null, (String)null, params);
    }

    public AlgebricksException(Throwable cause, int errorCode, Serializable ... params) {
        this("", errorCode, cause.getMessage(), cause, (String)null, params);
    }

    public AlgebricksException(String component, int errorCode, String message, Serializable ... params) {
        this(component, errorCode, message, (Throwable)null, (String)null, params);
    }

    public AlgebricksException(String component, int errorCode, Throwable cause, Serializable ... params) {
        this(component, errorCode, cause.getMessage(), cause, (String)null, params);
    }

    public AlgebricksException(String component, int errorCode, String message, Throwable cause, Serializable ... params) {
        this(component, errorCode, message, cause, (String)null, params);
    }

    public String getComponent() {
        return this.component;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage() {
        if (this.msgCache == null) {
            AlgebricksException algebricksException = this;
            synchronized (algebricksException) {
                this.msgCache = ErrorMessageUtil.formatMessage((String)this.component, (int)this.errorCode, (String)super.getMessage(), (Serializable[])this.params);
            }
        }
        return this.msgCache;
    }
}

