/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.replication.IFaultToleranceStrategy;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.control.common.controllers.NCConfig;

public class ClusterStateManager
implements IClusterStateManager {
    private static final Logger LOGGER = Logger.getLogger(ClusterStateManager.class.getName());
    public static final ClusterStateManager INSTANCE = new ClusterStateManager();
    private final Map<String, Map<IOption, Object>> activeNcConfiguration = new HashMap<String, Map<IOption, Object>>();
    private final Cluster cluster;
    private IClusterManagementWork.ClusterState state = IClusterManagementWork.ClusterState.UNUSABLE;
    private AlgebricksAbsolutePartitionConstraint clusterPartitionConstraint;
    private boolean globalRecoveryCompleted = false;
    private Map<String, ClusterPartition[]> node2PartitionsMap = null;
    private SortedMap<Integer, ClusterPartition> clusterPartitions = null;
    private String currentMetadataNode = null;
    private boolean metadataNodeActive = false;
    private Set<String> failedNodes = new HashSet<String>();
    private IFaultToleranceStrategy ftStrategy;

    private ClusterStateManager() {
        this.cluster = ClusterProperties.INSTANCE.getCluster();
        if (AppContextInfo.INSTANCE.initialized() && AppContextInfo.INSTANCE.getCCServiceContext() != null) {
            this.node2PartitionsMap = AppContextInfo.INSTANCE.getMetadataProperties().getNodePartitions();
            this.clusterPartitions = AppContextInfo.INSTANCE.getMetadataProperties().getClusterPartitions();
            this.currentMetadataNode = AppContextInfo.INSTANCE.getMetadataProperties().getMetadataNodeName();
            this.ftStrategy = AppContextInfo.INSTANCE.getFaultToleranceStrategy();
            this.ftStrategy.bindTo((IClusterStateManager)this);
        }
    }

    public synchronized void removeNCConfiguration(String nodeId) throws HyracksException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Removing configuration parameters for node id " + nodeId);
        }
        this.failedNodes.add(nodeId);
        this.ftStrategy.notifyNodeFailure(nodeId);
    }

    public synchronized void addNCConfiguration(String nodeId, Map<IOption, Object> configuration) throws HyracksException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Registering configuration parameters for node id " + nodeId);
        }
        this.activeNcConfiguration.put(nodeId, configuration);
        this.failedNodes.remove(nodeId);
        this.ftStrategy.notifyNodeJoin(nodeId);
    }

    public synchronized void setState(IClusterManagementWork.ClusterState state) {
        this.state = state;
        LOGGER.info("Cluster State is now " + state.name());
        this.notifyAll();
    }

    public void updateMetadataNode(String nodeId, boolean active) {
        this.currentMetadataNode = nodeId;
        this.metadataNodeActive = active;
        if (active) {
            LOGGER.info(String.format("Metadata node %s is now active", this.currentMetadataNode));
        }
    }

    public synchronized void updateNodePartitions(String nodeId, boolean active) throws HyracksDataException {
        ClusterPartition[] nodePartitions = this.node2PartitionsMap.get(nodeId);
        if (nodePartitions != null) {
            for (ClusterPartition p : nodePartitions) {
                this.updateClusterPartition(p.getPartitionId(), nodeId, active);
            }
        }
    }

    public synchronized void updateClusterPartition(Integer partitionNum, String activeNode, boolean active) {
        ClusterPartition clusterPartition = (ClusterPartition)this.clusterPartitions.get(partitionNum);
        if (clusterPartition != null) {
            clusterPartition.setActive(active);
            if (active) {
                clusterPartition.setActiveNodeId(activeNode);
            }
        }
    }

    public synchronized void refreshState() throws HyracksDataException {
        this.resetClusterPartitionConstraint();
        for (ClusterPartition p : this.clusterPartitions.values()) {
            if (p.isActive()) continue;
            this.setState(IClusterManagementWork.ClusterState.UNUSABLE);
            return;
        }
        this.setState(IClusterManagementWork.ClusterState.PENDING);
        LOGGER.info("Cluster is now " + this.state);
        if (this.metadataNodeActive) {
            AppContextInfo.INSTANCE.getMetadataBootstrap().init();
            this.setState(IClusterManagementWork.ClusterState.ACTIVE);
            LOGGER.info("Cluster is now " + this.state);
            this.notifyAll();
            AppContextInfo.INSTANCE.getGlobalRecoveryManager().startGlobalRecovery();
        }
    }

    public synchronized void waitForState(IClusterManagementWork.ClusterState waitForState) throws HyracksDataException, InterruptedException {
        while (this.state != waitForState) {
            this.wait();
        }
    }

    public synchronized boolean waitForState(IClusterManagementWork.ClusterState waitForState, long timeout, TimeUnit unit) throws HyracksDataException, InterruptedException {
        long startMillis = System.currentTimeMillis();
        long endMillis = startMillis + unit.toMillis(timeout);
        while (this.state != waitForState) {
            long millisToSleep = endMillis - System.currentTimeMillis();
            if (millisToSleep > 0L) {
                this.wait(millisToSleep);
                continue;
            }
            return false;
        }
        return true;
    }

    public synchronized String[] getIODevices(String nodeId) {
        Map<IOption, Object> ncConfig = this.activeNcConfiguration.get(nodeId);
        if (ncConfig == null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Configuration parameters for nodeId " + nodeId + " not found. The node has not joined yet or has left.");
            }
            return new String[0];
        }
        return (String[])ncConfig.get(NCConfig.Option.IODEVICES);
    }

    public IClusterManagementWork.ClusterState getState() {
        return this.state;
    }

    public synchronized Node getAvailableSubstitutionNode() {
        List subNodes = this.cluster.getSubstituteNodes() == null ? null : this.cluster.getSubstituteNodes().getNode();
        return subNodes == null || subNodes.isEmpty() ? null : (Node)subNodes.get(0);
    }

    public synchronized Set<String> getParticipantNodes() {
        HashSet<String> participantNodes = new HashSet<String>();
        for (String pNode : this.activeNcConfiguration.keySet()) {
            participantNodes.add(pNode);
        }
        return participantNodes;
    }

    public synchronized AlgebricksAbsolutePartitionConstraint getClusterLocations() {
        if (this.clusterPartitionConstraint == null) {
            this.resetClusterPartitionConstraint();
        }
        return this.clusterPartitionConstraint;
    }

    private synchronized void resetClusterPartitionConstraint() {
        ArrayList<String> clusterActiveLocations = new ArrayList<String>();
        for (ClusterPartition p : this.clusterPartitions.values()) {
            if (!p.isActive()) continue;
            clusterActiveLocations.add(p.getActiveNodeId());
        }
        this.clusterPartitionConstraint = new AlgebricksAbsolutePartitionConstraint(clusterActiveLocations.toArray(new String[0]));
    }

    public boolean isGlobalRecoveryCompleted() {
        return this.globalRecoveryCompleted;
    }

    public void setGlobalRecoveryCompleted(boolean globalRecoveryCompleted) {
        this.globalRecoveryCompleted = globalRecoveryCompleted;
    }

    public boolean isClusterActive() {
        if (this.cluster == null) {
            return true;
        }
        return this.state == IClusterManagementWork.ClusterState.ACTIVE;
    }

    public static int getNumberOfNodes() {
        return AppContextInfo.INSTANCE.getMetadataProperties().getNodeNames().size();
    }

    public synchronized ClusterPartition[] getNodePartitions(String nodeId) {
        return this.node2PartitionsMap.get(nodeId);
    }

    public synchronized int getNodePartitionsCount(String node) {
        if (this.node2PartitionsMap.containsKey(node)) {
            return this.node2PartitionsMap.get(node).length;
        }
        return 0;
    }

    public synchronized ClusterPartition[] getClusterPartitons() {
        ArrayList<ClusterPartition> partitons = new ArrayList<ClusterPartition>();
        for (ClusterPartition partition : this.clusterPartitions.values()) {
            partitons.add(partition);
        }
        return partitons.toArray(new ClusterPartition[0]);
    }

    public synchronized boolean isMetadataNodeActive() {
        return this.metadataNodeActive;
    }

    public synchronized ObjectNode getClusterStateDescription() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode stateDescription = om.createObjectNode();
        stateDescription.put("state", this.state.name());
        stateDescription.put("metadata_node", this.currentMetadataNode);
        ArrayNode ncs = om.createArrayNode();
        stateDescription.set("ncs", (JsonNode)ncs);
        for (Map.Entry<String, ClusterPartition[]> entry : this.node2PartitionsMap.entrySet()) {
            ObjectNode nodeJSON = om.createObjectNode();
            nodeJSON.put("node_id", entry.getKey());
            boolean allActive = true;
            boolean anyActive = false;
            HashSet partitions = new HashSet();
            for (ClusterPartition part : entry.getValue()) {
                HashMap<String, Object> partition = new HashMap<String, Object>();
                partition.put("partition_id", "partition_" + part.getPartitionId());
                partition.put("active", part.isActive());
                partitions.add(partition);
                boolean bl = allActive = allActive && part.isActive();
                if (!allActive) continue;
                anyActive = true;
            }
            nodeJSON.put("state", this.failedNodes.contains(entry.getKey()) ? "FAILED" : (allActive ? "ACTIVE" : (anyActive ? "PARTIALLY_ACTIVE" : "INACTIVE")));
            nodeJSON.putPOJO("partitions", partitions);
            ncs.add((JsonNode)nodeJSON);
        }
        return stateDescription;
    }

    public synchronized ObjectNode getClusterStateSummary() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode stateDescription = om.createObjectNode();
        stateDescription.put("state", this.state.name());
        stateDescription.putPOJO("metadata_node", (Object)this.currentMetadataNode);
        stateDescription.putPOJO("partitions", this.clusterPartitions);
        return stateDescription;
    }

    public Map<String, Map<IOption, Object>> getActiveNcConfiguration() {
        return Collections.unmodifiableMap(this.activeNcConfiguration);
    }

    public String getCurrentMetadataNodeId() {
        return this.currentMetadataNode;
    }
}

