/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.utils;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.config.ActiveProperties;
import org.apache.asterix.common.config.BuildProperties;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.config.ExtensionProperties;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.config.IPropertiesProvider;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.config.NodeProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.config.TransactionProperties;
import org.apache.asterix.common.dataflow.IApplicationContextInfo;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.IMetadataBootstrap;
import org.apache.asterix.common.replication.IFaultToleranceStrategy;
import org.apache.asterix.common.transactions.IResourceIdManager;
import org.apache.asterix.runtime.utils.RuntimeComponentsProvider;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManagerProvider;
import org.apache.hyracks.storage.common.IStorageManager;

public class AppContextInfo
implements IApplicationContextInfo,
IPropertiesProvider {
    public static final AppContextInfo INSTANCE = new AppContextInfo();
    private ICCServiceContext ccServiceCtx;
    private IGlobalRecoveryManager globalRecoveryManager;
    private ILibraryManager libraryManager;
    private IResourceIdManager resourceIdManager;
    private CompilerProperties compilerProperties;
    private ExternalProperties externalProperties;
    private MetadataProperties metadataProperties;
    private StorageProperties storageProperties;
    private TransactionProperties txnProperties;
    private ActiveProperties activeProperties;
    private BuildProperties buildProperties;
    private ReplicationProperties replicationProperties;
    private ExtensionProperties extensionProperties;
    private MessagingProperties messagingProperties;
    private NodeProperties nodeProperties;
    private Supplier<IMetadataBootstrap> metadataBootstrapSupplier;
    private IHyracksClientConnection hcc;
    private Object extensionManager;
    private volatile boolean initialized = false;
    private IFaultToleranceStrategy ftStrategy;

    private AppContextInfo() {
    }

    public static synchronized void initialize(ICCServiceContext ccServiceCtx, IHyracksClientConnection hcc, ILibraryManager libraryManager, IResourceIdManager resourceIdManager, Supplier<IMetadataBootstrap> metadataBootstrapSupplier, IGlobalRecoveryManager globalRecoveryManager, IFaultToleranceStrategy ftStrategy) throws AsterixException, IOException {
        if (AppContextInfo.INSTANCE.initialized) {
            throw new AsterixException(AppContextInfo.class.getSimpleName() + " has been initialized already");
        }
        AppContextInfo.INSTANCE.initialized = true;
        AppContextInfo.INSTANCE.ccServiceCtx = ccServiceCtx;
        AppContextInfo.INSTANCE.hcc = hcc;
        AppContextInfo.INSTANCE.libraryManager = libraryManager;
        AppContextInfo.INSTANCE.resourceIdManager = resourceIdManager;
        PropertiesAccessor propertiesAccessor = PropertiesAccessor.getInstance((IApplicationConfig)ccServiceCtx.getAppConfig());
        AppContextInfo.INSTANCE.compilerProperties = new CompilerProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.externalProperties = new ExternalProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.metadataProperties = new MetadataProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.storageProperties = new StorageProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.txnProperties = new TransactionProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.activeProperties = new ActiveProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.extensionProperties = new ExtensionProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.replicationProperties = new ReplicationProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.ftStrategy = ftStrategy;
        AppContextInfo.INSTANCE.hcc = hcc;
        AppContextInfo.INSTANCE.buildProperties = new BuildProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.messagingProperties = new MessagingProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.nodeProperties = new NodeProperties(propertiesAccessor);
        AppContextInfo.INSTANCE.metadataBootstrapSupplier = metadataBootstrapSupplier;
        AppContextInfo.INSTANCE.globalRecoveryManager = globalRecoveryManager;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public ICCServiceContext getCCServiceContext() {
        return this.ccServiceCtx;
    }

    public StorageProperties getStorageProperties() {
        return this.storageProperties;
    }

    public TransactionProperties getTransactionProperties() {
        return this.txnProperties;
    }

    public CompilerProperties getCompilerProperties() {
        return this.compilerProperties;
    }

    public MetadataProperties getMetadataProperties() {
        return this.metadataProperties;
    }

    public ExternalProperties getExternalProperties() {
        return this.externalProperties;
    }

    public ActiveProperties getActiveProperties() {
        return this.activeProperties;
    }

    public BuildProperties getBuildProperties() {
        return this.buildProperties;
    }

    public IHyracksClientConnection getHcc() {
        return this.hcc;
    }

    public IIndexLifecycleManagerProvider getIndexLifecycleManagerProvider() {
        return RuntimeComponentsProvider.RUNTIME_PROVIDER;
    }

    public IStorageManager getStorageManager() {
        return RuntimeComponentsProvider.RUNTIME_PROVIDER;
    }

    public ReplicationProperties getReplicationProperties() {
        return this.replicationProperties;
    }

    public IGlobalRecoveryManager getGlobalRecoveryManager() {
        return this.globalRecoveryManager;
    }

    public ILibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public Object getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(Object extensionManager) {
        this.extensionManager = extensionManager;
    }

    public ExtensionProperties getExtensionProperties() {
        return this.extensionProperties;
    }

    public MessagingProperties getMessagingProperties() {
        return this.messagingProperties;
    }

    public NodeProperties getNodeProperties() {
        return this.nodeProperties;
    }

    public IResourceIdManager getResourceIdManager() {
        return this.resourceIdManager;
    }

    public IMetadataBootstrap getMetadataBootstrap() {
        return this.metadataBootstrapSupplier.get();
    }

    public IFaultToleranceStrategy getFaultToleranceStrategy() {
        return this.ftStrategy;
    }
}

