/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.nio.ByteBuffer;
import org.apache.asterix.runtime.operators.LSMPrimaryUpsertOperatorNodePushable;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMIndexInsertUpdateDeleteOperatorNodePushable;

public class LSMSecondaryUpsertOperatorNodePushable
extends LSMIndexInsertUpdateDeleteOperatorNodePushable {
    private final PermutingFrameTupleReference prevValueTuple = new PermutingFrameTupleReference();
    private int numberOfFields;
    private boolean isNewNull = false;
    private boolean isPrevValueNull = false;
    private AbstractIndexModificationOperationCallback abstractModCallback;

    public LSMSecondaryUpsertOperatorNodePushable(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, int[] fieldPermutation, IRecordDescriptorProvider recordDescProvider, int[] prevValuePermutation) throws HyracksDataException {
        super(opDesc, ctx, partition, fieldPermutation, recordDescProvider, IndexOperation.UPSERT);
        this.prevValueTuple.setFieldPermutation(prevValuePermutation);
        this.numberOfFields = prevValuePermutation.length;
    }

    public void open() throws HyracksDataException {
        super.open();
        this.abstractModCallback = (AbstractIndexModificationOperationCallback)this.modCallback;
    }

    public static boolean equals(byte[] a, int aOffset, int aLength, byte[] b, int bOffset, int bLength) {
        if (aLength != bLength) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[aOffset + i] == b[bOffset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalTuples(PermutingFrameTupleReference t1, PermutingFrameTupleReference t2, int numOfFields) throws HyracksDataException {
        byte[] t1Data = t1.getFieldData(0);
        byte[] t2Data = t2.getFieldData(0);
        for (int i = 0; i < numOfFields; ++i) {
            if (LSMSecondaryUpsertOperatorNodePushable.equals(t1Data, t1.getFieldStart(i), t1.getFieldLength(i), t2Data, t2.getFieldStart(i), t2.getFieldLength(i))) continue;
            return false;
        }
        return true;
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        ILSMIndexAccessor lsmAccessor = (ILSMIndexAccessor)this.indexAccessor;
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            try {
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                this.prevValueTuple.reset((IFrameTupleAccessor)this.accessor, i);
                this.isNewNull = LSMPrimaryUpsertOperatorNodePushable.isNull((ITupleReference)this.tuple, 0);
                this.isPrevValueNull = LSMPrimaryUpsertOperatorNodePushable.isNull((ITupleReference)this.prevValueTuple, 0);
                if (this.isNewNull && this.isPrevValueNull || LSMSecondaryUpsertOperatorNodePushable.equalTuples(this.tuple, this.prevValueTuple, this.numberOfFields)) continue;
                if (!this.isPrevValueNull) {
                    this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.DELETE);
                    lsmAccessor.forceDelete((ITupleReference)this.prevValueTuple);
                }
                if (this.isNewNull) continue;
                this.abstractModCallback.setOp(AbstractIndexModificationOperationCallback.Operation.INSERT);
                lsmAccessor.forceInsert((ITupleReference)this.tuple);
                continue;
            }
            catch (HyracksDataException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
        FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
    }
}

