/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.message;

import java.util.Set;
import org.apache.asterix.common.messaging.api.IApplicationMessage;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.transactions.IResourceIdManager;
import org.apache.asterix.runtime.message.ReportMaxResourceIdRequestMessage;
import org.apache.asterix.runtime.message.ResourceIdRequestResponseMessage;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.service.IControllerService;

public class ResourceIdRequestMessage
implements IApplicationMessage {
    private static final long serialVersionUID = 1L;
    private final String src;

    public ResourceIdRequestMessage(String src) {
        this.src = src;
    }

    public void handle(IControllerService cs) throws HyracksDataException, InterruptedException {
        try {
            ICCMessageBroker broker = (ICCMessageBroker)AppContextInfo.INSTANCE.getCCServiceContext().getMessageBroker();
            ResourceIdRequestResponseMessage reponse = new ResourceIdRequestResponseMessage();
            if (!ClusterStateManager.INSTANCE.isClusterActive()) {
                reponse.setResourceId(-1L);
                reponse.setException(new Exception("Cannot generate global resource id when cluster is not active."));
            } else {
                IResourceIdManager resourceIdManager = AppContextInfo.INSTANCE.getResourceIdManager();
                reponse.setResourceId(resourceIdManager.createResourceId());
                if (reponse.getResourceId() < 0L) {
                    reponse.setException(new Exception("One or more nodes has not reported max resource id."));
                }
                this.requestMaxResourceID(resourceIdManager, broker);
            }
            broker.sendApplicationMessageToNC((IApplicationMessage)reponse, this.src);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void requestMaxResourceID(IResourceIdManager resourceIdManager, ICCMessageBroker broker) throws Exception {
        Set<String> getParticipantNodes = ClusterStateManager.INSTANCE.getParticipantNodes();
        ReportMaxResourceIdRequestMessage msg = new ReportMaxResourceIdRequestMessage();
        for (String nodeId : getParticipantNodes) {
            if (resourceIdManager.reported(nodeId)) continue;
            broker.sendApplicationMessageToNC((IApplicationMessage)msg, nodeId);
        }
    }

    public String toString() {
        return ReportMaxResourceIdRequestMessage.class.getSimpleName();
    }
}

