/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.message;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.messaging.api.IApplicationMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.transactions.IResourceIdManager;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.control.nc.NodeControllerService;

public class ReportMaxResourceIdMessage
implements IApplicationMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ReportMaxResourceIdMessage.class.getName());
    private final long maxResourceId;
    private final String src;

    public ReportMaxResourceIdMessage(String src, long maxResourceId) {
        this.src = src;
        this.maxResourceId = maxResourceId;
    }

    public long getMaxResourceId() {
        return this.maxResourceId;
    }

    public void handle(IControllerService cs) throws HyracksDataException, InterruptedException {
        IResourceIdManager resourceIdManager = AppContextInfo.INSTANCE.getResourceIdManager();
        resourceIdManager.report(this.src, this.maxResourceId);
    }

    public static void send(NodeControllerService cs) throws HyracksDataException {
        NodeControllerService ncs = cs;
        IAppRuntimeContext appContext = (IAppRuntimeContext)ncs.getApplicationContext();
        long maxResourceId = Math.max(appContext.getLocalResourceRepository().maxId(), 100L);
        ReportMaxResourceIdMessage maxResourceIdMsg = new ReportMaxResourceIdMessage(ncs.getId(), maxResourceId);
        try {
            ((INCMessageBroker)ncs.getContext().getMessageBroker()).sendMessageToCC((IApplicationMessage)maxResourceIdMsg);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to report max local resource id", e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public String toString() {
        return ReportMaxResourceIdMessage.class.getSimpleName();
    }
}

