/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.visitors;

import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.BinaryHashMap;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.visitors.DeepEqualityVisitor;
import org.apache.asterix.runtime.evaluators.visitors.DeepEqualityVisitorHelper;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.util.BinaryEntry;

class RecordDeepEqualityChecker {
    private final Pair<IVisitablePointable, Boolean> nestedVisitorArg = new Pair(null, (Object)false);
    private final DeepEqualityVisitorHelper deepEqualityVisitorHelper = new DeepEqualityVisitorHelper();
    private DeepEqualityVisitor visitor;
    private BinaryEntry keyEntry = new BinaryEntry();
    private BinaryEntry valEntry = new BinaryEntry();
    private BinaryHashMap hashMap;

    public RecordDeepEqualityChecker(int tableSize, int tableFrameSize) {
        this.hashMap = this.deepEqualityVisitorHelper.initializeHashMap(tableSize, tableFrameSize, this.valEntry);
    }

    public RecordDeepEqualityChecker() {
        this.hashMap = this.deepEqualityVisitorHelper.initializeHashMap(this.valEntry);
    }

    public boolean accessRecord(IVisitablePointable recPointableLeft, IVisitablePointable recPointableRight, DeepEqualityVisitor visitor) throws HyracksDataException, AsterixException {
        if (recPointableLeft.equals(recPointableRight)) {
            return true;
        }
        this.visitor = visitor;
        this.hashMap.clear();
        ARecordVisitablePointable recLeft = (ARecordVisitablePointable)recPointableLeft;
        List fieldNamesLeft = recLeft.getFieldNames();
        ARecordVisitablePointable recRight = (ARecordVisitablePointable)recPointableRight;
        List fieldNamesRight = recRight.getFieldNames();
        int sizeLeft = fieldNamesLeft.size();
        int sizeRight = fieldNamesRight.size();
        if (sizeLeft != sizeRight) {
            return false;
        }
        for (int i = 0; i < sizeLeft; ++i) {
            IVisitablePointable fieldName = (IVisitablePointable)fieldNamesLeft.get(i);
            this.keyEntry.set(fieldName.getByteArray(), fieldName.getStartOffset(), fieldName.getLength());
            IntegerPointable.setInteger((byte[])this.valEntry.getBuf(), (int)0, (int)i);
            this.hashMap.put(this.keyEntry, this.valEntry);
        }
        return this.compareValues(recLeft.getFieldTypeTags(), recLeft.getFieldValues(), fieldNamesRight, recRight.getFieldTypeTags(), recRight.getFieldValues());
    }

    private boolean compareValues(List<IVisitablePointable> fieldTypesLeft, List<IVisitablePointable> fieldValuesLeft, List<IVisitablePointable> fieldNamesRight, List<IVisitablePointable> fieldTypesRight, List<IVisitablePointable> fieldValuesRight) throws HyracksDataException, AsterixException {
        for (int i = 0; i < fieldNamesRight.size(); ++i) {
            IVisitablePointable fieldName = fieldNamesRight.get(i);
            this.keyEntry.set(fieldName.getByteArray(), fieldName.getStartOffset(), fieldName.getLength());
            BinaryEntry entry = this.hashMap.get(this.keyEntry);
            if (entry == null) {
                return false;
            }
            int fieldIdLeft = AInt32SerializerDeserializer.getInt((byte[])entry.getBuf(), (int)entry.getOffset());
            ATypeTag fieldTypeLeft = PointableHelper.getTypeTag((IValueReference)fieldTypesLeft.get(fieldIdLeft));
            if (fieldTypeLeft.isDerivedType() && fieldTypeLeft != PointableHelper.getTypeTag((IValueReference)fieldTypesRight.get(i))) {
                return false;
            }
            this.nestedVisitorArg.first = fieldValuesRight.get(i);
            fieldValuesLeft.get(fieldIdLeft).accept((IVisitablePointableVisitor)this.visitor, this.nestedVisitorArg);
            if (((Boolean)this.nestedVisitorArg.second).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

