/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.visitors;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.BinaryHashMap;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.visitors.DeepEqualityVisitor;
import org.apache.asterix.runtime.evaluators.visitors.DeepEqualityVisitorHelper;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.util.BinaryEntry;

class ListDeepEqualityChecker {
    private DeepEqualityVisitor visitor;
    private BinaryHashMap hashMap;
    private BinaryEntry keyEntry = new BinaryEntry();
    private BinaryEntry valEntry = new BinaryEntry();
    private final DeepEqualityVisitorHelper deepEqualityVisitorHelper = new DeepEqualityVisitorHelper();
    private final Pair<IVisitablePointable, Boolean> itemVisitorArg = new Pair(null, (Object)false);

    public ListDeepEqualityChecker() {
        this.hashMap = this.deepEqualityVisitorHelper.initializeHashMap(this.valEntry);
    }

    public boolean accessList(IVisitablePointable listPointableLeft, IVisitablePointable listPointableRight, DeepEqualityVisitor visitor) throws IOException, AsterixException {
        this.visitor = visitor;
        AListVisitablePointable listLeft = (AListVisitablePointable)listPointableLeft;
        List itemsLeft = listLeft.getItems();
        List itemTagTypesLeft = listLeft.getItemTags();
        AListVisitablePointable listRight = (AListVisitablePointable)listPointableRight;
        List itemsRight = listRight.getItems();
        List itemTagTypesRight = listRight.getItemTags();
        if (itemsLeft.size() != itemsRight.size()) {
            return false;
        }
        boolean isOrderedRight = listLeft.ordered();
        if (isOrderedRight != listRight.ordered()) {
            return false;
        }
        if (isOrderedRight) {
            return this.processOrderedList(itemsLeft, itemTagTypesLeft, itemsRight, itemTagTypesRight);
        }
        return this.processUnorderedList(itemsLeft, itemTagTypesLeft, itemsRight, itemTagTypesRight);
    }

    private boolean processOrderedList(List<IVisitablePointable> itemsLeft, List<IVisitablePointable> itemTagTypesLeft, List<IVisitablePointable> itemsRight, List<IVisitablePointable> itemTagTypesRight) throws HyracksDataException, AsterixException {
        for (int i = 0; i < itemsLeft.size(); ++i) {
            ATypeTag fieldTypeLeft = PointableHelper.getTypeTag((IValueReference)itemTagTypesLeft.get(i));
            if (fieldTypeLeft.isDerivedType() && fieldTypeLeft != PointableHelper.getTypeTag((IValueReference)itemTagTypesRight.get(i))) {
                return false;
            }
            this.itemVisitorArg.first = itemsRight.get(i);
            itemsLeft.get(i).accept((IVisitablePointableVisitor)this.visitor, this.itemVisitorArg);
            if (((Boolean)this.itemVisitorArg.second).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean processUnorderedList(List<IVisitablePointable> itemsLeft, List<IVisitablePointable> itemTagTypesLeft, List<IVisitablePointable> itemsRight, List<IVisitablePointable> itemTagTypesRight) throws HyracksDataException, AsterixException {
        this.hashMap.clear();
        for (int i = 0; i < itemsLeft.size(); ++i) {
            IVisitablePointable item = itemsLeft.get(i);
            byte[] buf = item.getByteArray();
            int off = item.getStartOffset();
            int len = item.getLength();
            this.keyEntry.set(buf, off, len);
            IntegerPointable.setInteger((byte[])this.valEntry.getBuf(), (int)0, (int)i);
            this.hashMap.put(this.keyEntry, this.valEntry);
        }
        return this.probeHashMap(itemsLeft, itemTagTypesLeft, itemsRight, itemTagTypesRight);
    }

    private boolean probeHashMap(List<IVisitablePointable> itemsLeft, List<IVisitablePointable> itemTagTypesLeft, List<IVisitablePointable> itemsRight, List<IVisitablePointable> itemTagTypesRight) throws HyracksDataException, AsterixException {
        for (int indexRight = 0; indexRight < itemsRight.size(); ++indexRight) {
            IVisitablePointable itemRight = itemsRight.get(indexRight);
            byte[] buf = itemRight.getByteArray();
            int off = itemRight.getStartOffset();
            int len = itemRight.getLength();
            this.keyEntry.set(buf, off, len);
            BinaryEntry entry = this.hashMap.get(this.keyEntry);
            if (entry == null) {
                return false;
            }
            int indexLeft = IntegerPointable.getInteger((byte[])entry.getBuf(), (int)entry.getOffset());
            ATypeTag fieldTypeLeft = PointableHelper.getTypeTag((IValueReference)itemTagTypesLeft.get(indexLeft));
            if (fieldTypeLeft.isDerivedType() && fieldTypeLeft != PointableHelper.getTypeTag((IValueReference)itemTagTypesRight.get(indexRight))) {
                return false;
            }
            this.itemVisitorArg.first = itemRight;
            itemsLeft.get(indexLeft).accept((IVisitablePointableVisitor)this.visitor, this.itemVisitorArg);
            if (((Boolean)this.itemVisitorArg.second).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

