/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.visitors;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.visitors.ListDeepEqualityChecker;
import org.apache.asterix.runtime.evaluators.visitors.RecordDeepEqualityChecker;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

public class DeepEqualityVisitor
implements IVisitablePointableVisitor<Void, Pair<IVisitablePointable, Boolean>> {
    private final Map<IVisitablePointable, ListDeepEqualityChecker> lpointableToEquality = new HashMap<IVisitablePointable, ListDeepEqualityChecker>();
    private final Map<IVisitablePointable, RecordDeepEqualityChecker> rpointableToEquality = new HashMap<IVisitablePointable, RecordDeepEqualityChecker>();

    public Void visit(AListVisitablePointable pointable, Pair<IVisitablePointable, Boolean> arg) throws AsterixException {
        ListDeepEqualityChecker listDeepEqualityChecker = this.lpointableToEquality.get(pointable);
        if (listDeepEqualityChecker == null) {
            listDeepEqualityChecker = new ListDeepEqualityChecker();
            this.lpointableToEquality.put((IVisitablePointable)pointable, listDeepEqualityChecker);
        }
        try {
            arg.second = listDeepEqualityChecker.accessList((IVisitablePointable)pointable, (IVisitablePointable)arg.first, this);
        }
        catch (Exception e) {
            throw new AsterixException((Throwable)e);
        }
        return null;
    }

    public Void visit(ARecordVisitablePointable pointable, Pair<IVisitablePointable, Boolean> arg) throws AsterixException {
        RecordDeepEqualityChecker recDeepEqualityChecker = this.rpointableToEquality.get(pointable);
        if (recDeepEqualityChecker == null) {
            recDeepEqualityChecker = new RecordDeepEqualityChecker();
            this.rpointableToEquality.put((IVisitablePointable)pointable, recDeepEqualityChecker);
        }
        try {
            arg.second = recDeepEqualityChecker.accessRecord((IVisitablePointable)pointable, (IVisitablePointable)arg.first, this);
        }
        catch (Exception e) {
            throw new AsterixException((Throwable)e);
        }
        return null;
    }

    public Void visit(AFlatValuePointable pointable, Pair<IVisitablePointable, Boolean> arg) throws AsterixException {
        if (pointable.equals(arg.first)) {
            arg.second = true;
            return null;
        }
        try {
            ATypeTag tt1 = PointableHelper.getTypeTag((IValueReference)pointable);
            ATypeTag tt2 = PointableHelper.getTypeTag((IValueReference)arg.first);
            if (tt1 != tt2) {
                if (!ATypeHierarchy.isSameTypeDomain((ATypeTag)tt1, (ATypeTag)tt2, (boolean)false)) {
                    arg.second = false;
                } else {
                    ATypeHierarchy.Domain domain = ATypeHierarchy.getTypeDomain((ATypeTag)tt1);
                    byte[] b1 = pointable.getByteArray();
                    byte[] b2 = ((IVisitablePointable)arg.first).getByteArray();
                    if (domain == ATypeHierarchy.Domain.NUMERIC) {
                        int s1 = pointable.getStartOffset();
                        int s2 = ((IVisitablePointable)arg.first).getStartOffset();
                        arg.second = Math.abs(ATypeHierarchy.getDoubleValue((String)"deep-equal", (int)0, (byte[])b1, (int)s1) - ATypeHierarchy.getDoubleValue((String)"deep-equal", (int)1, (byte[])b2, (int)s2)) < 1.0E-10;
                    } else {
                        arg.second = false;
                    }
                }
            } else {
                arg.second = PointableHelper.byteArrayEqual((IValueReference)pointable, (IValueReference)arg.first, 1);
            }
        }
        catch (HyracksDataException e) {
            throw new AsterixException((Throwable)e);
        }
        return null;
    }
}

