/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.staticcodegen;

import java.util.List;
import org.apache.asterix.runtime.evaluators.staticcodegen.CodeGenUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class RenameClassVisitor
extends ClassVisitor {
    private final List<Pair<String, String>> nameMapping;

    public RenameClassVisitor(ClassVisitor downStreamVisitor, List<Pair<String, String>> nameMapping) {
        super(327680, downStreamVisitor);
        this.nameMapping = nameMapping;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, this.applyMapping(name), signature, this.applyMapping(superName), interfaces);
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if ((access & 1) != 0 && (access & 8) != 0) {
            super.visitInnerClass(name, outerName, innerName, access);
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return this.cv.visitField(access, name, this.applyMapping(desc), this.applyMapping(signature), value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, this.applyMapping(desc), this.applyMapping(signature), exceptions);
        if (mv != null) {
            return new MethodVisitor(327680, mv){

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    this.mv.visitFieldInsn(opcode, RenameClassVisitor.this.applyMapping(owner), RenameClassVisitor.this.applyMapping(name), RenameClassVisitor.this.applyMapping(desc));
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    this.mv.visitMethodInsn(opcode, RenameClassVisitor.this.applyMapping(owner), name, RenameClassVisitor.this.applyMapping(desc), itf);
                }

                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                    this.mv.visitLocalVariable(name, RenameClassVisitor.this.applyMapping(desc), RenameClassVisitor.this.applyMapping(signature), start, end, index);
                }

                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                    if (local != null) {
                        for (int index = 0; index < local.length; ++index) {
                            if (!(local[index] instanceof String)) continue;
                            local[index] = RenameClassVisitor.this.applyMapping((String)local[index]);
                        }
                    }
                    this.mv.visitFrame(type, nLocal, local, nStack, stack);
                }

                public void visitTypeInsn(int opcode, String type) {
                    this.mv.visitTypeInsn(opcode, RenameClassVisitor.this.applyMapping(type));
                }
            };
        }
        return null;
    }

    private String applyMapping(String inputStr) {
        return CodeGenUtil.applyMapping(this.nameMapping, inputStr);
    }
}

