/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.pointables.nonvisitor.AIntervalPointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.temporal.IntervalLogic;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class GetOverlappingIntervalDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new GetOverlappingIntervalDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    protected final IntervalLogic il = new IntervalLogic();
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private TaggedValuePointable argPtr0 = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
                    private TaggedValuePointable argPtr1 = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
                    private AIntervalPointable interval0 = (AIntervalPointable)AIntervalPointable.FACTORY.createPointable();
                    private AIntervalPointable interval1 = (AIntervalPointable)AIntervalPointable.FACTORY.createPointable();
                    private IScalarEvaluator eval0;
                    private IScalarEvaluator eval1;
                    private final AMutableInterval aInterval;
                    private final ISerializerDeserializer<ANull> nullSerde;
                    private final ISerializerDeserializer<AInterval> intervalSerde;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.aInterval = new AMutableInterval(0L, 0L, -1);
                        this.nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
                        this.intervalSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINTERVAL);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, (IPointable)this.argPtr0);
                        this.eval1.evaluate(tuple, (IPointable)this.argPtr1);
                        byte type0 = this.argPtr0.getTag();
                        byte type1 = this.argPtr1.getTag();
                        if (type0 == ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG && type0 == type1) {
                            this.argPtr0.getValue((IPointable)this.interval0);
                            this.argPtr1.getValue((IPointable)this.interval1);
                            byte intervalType0 = this.interval0.getType();
                            byte intervalType1 = this.interval1.getType();
                            if (intervalType0 != intervalType1) {
                                throw new IncompatibleTypeException(GetOverlappingIntervalDescriptor.this.getIdentifier(), intervalType0, intervalType1);
                            }
                            if (this.il.overlaps(this.interval0, this.interval1) || this.il.overlappedBy(this.interval0, this.interval1) || this.il.covers(this.interval0, this.interval1) || this.il.coveredBy(this.interval0, this.interval1)) {
                                long start = Math.max(this.interval0.getStartValue(), this.interval1.getStartValue());
                                long end = Math.min(this.interval0.getEndValue(), this.interval1.getEndValue());
                                this.aInterval.setValue(start, end, intervalType0);
                                this.intervalSerde.serialize((Object)this.aInterval, this.out);
                            } else {
                                this.nullSerde.serialize((Object)ANull.NULL, this.out);
                            }
                            result.set((IValueReference)this.resultStorage);
                            return;
                        }
                        if (type0 != ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG) {
                            throw new TypeMismatchException(GetOverlappingIntervalDescriptor.this.getIdentifier(), (Integer)0, type0, ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                        }
                        throw new IncompatibleTypeException(GetOverlappingIntervalDescriptor.this.getIdentifier(), type0, type1);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.GET_OVERLAPPING_INTERVAL;
    }
}

