/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.binary;

import java.io.IOException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.binary.AbstractBinaryScalarEvaluator;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;

public class BinaryConcatDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new BinaryConcatDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.BINARY_CONCAT;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                return new AbstractBinaryScalarEvaluator(ctx, args){
                    private final ListAccessor listAccessor;
                    private final byte[] metaBuffer;
                    private ISerializerDeserializer<ANull> nullSerde;
                    private ISerializerDeserializer<AMissing> missingSerde;
                    {
                        this.listAccessor = new ListAccessor();
                        this.metaBuffer = new byte[5];
                        this.nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
                        this.missingSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AMISSING);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.evaluators[0].evaluate(tuple, this.pointables[0]);
                        byte[] data = this.pointables[0].getByteArray();
                        int offset = this.pointables[0].getStartOffset();
                        byte typeTag = data[offset];
                        if (typeTag != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG && typeTag != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                            throw new TypeMismatchException(BinaryConcatDescriptor.this.getIdentifier(), (Integer)0, typeTag, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
                        }
                        try {
                            this.listAccessor.reset(data, offset);
                            int concatLength = 0;
                            for (int i = 0; i < this.listAccessor.size(); ++i) {
                                int itemOffset = this.listAccessor.getItemOffset(i);
                                ATypeTag itemType = this.listAccessor.getItemType(itemOffset);
                                if (itemType != ATypeTag.BINARY) {
                                    if (this.serializeUnknownIfAnyUnknown(itemType)) {
                                        result.set((IValueReference)this.resultStorage);
                                        return;
                                    }
                                    throw new UnsupportedItemTypeException(BinaryConcatDescriptor.this.getIdentifier(), itemType.serialize());
                                }
                                concatLength += ByteArrayPointable.getContentLength((byte[])data, (int)itemOffset);
                            }
                            this.dataOutput.writeByte(ATypeTag.SERIALIZED_BINARY_TYPE_TAG);
                            int metaLen = VarLenIntEncoderDecoder.encode((int)concatLength, (byte[])this.metaBuffer, (int)0);
                            this.dataOutput.write(this.metaBuffer, 0, metaLen);
                            for (int i = 0; i < this.listAccessor.size(); ++i) {
                                int itemOffset = this.listAccessor.getItemOffset(i);
                                int length = ByteArrayPointable.getContentLength((byte[])data, (int)itemOffset);
                                this.dataOutput.write(data, itemOffset + ByteArrayPointable.getNumberBytesToStoreMeta((int)length), length);
                            }
                        }
                        catch (IOException e) {
                            throw new HyracksDataException((Throwable)e);
                        }
                        catch (AsterixException e) {
                            throw new HyracksDataException((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }

                    private boolean serializeUnknownIfAnyUnknown(ATypeTag ... tags) throws HyracksDataException {
                        for (ATypeTag typeTag : tags) {
                            if (typeTag == ATypeTag.NULL) {
                                this.nullSerde.serialize((Object)ANull.NULL, this.dataOutput);
                                return true;
                            }
                            if (typeTag != ATypeTag.MISSING) continue;
                            this.missingSerde.serialize((Object)AMissing.MISSING, this.dataOutput);
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }
}

