/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class CreateQueryUIDDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new CreateQueryUIDDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;
            private static final int BINARY_LENGTH = 14;
            private static final int PAYLOAD_START = 2;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                final byte[] uidBytes = new byte[14];
                uidBytes[0] = ATypeTag.SERIALIZED_BINARY_TYPE_TAG;
                uidBytes[1] = 12;
                IntegerPointable.setInteger((byte[])uidBytes, (int)2, (int)ctx.getTaskAttemptId().getTaskId().getPartition());
                return new IScalarEvaluator(){

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        int i = 13;
                        while (i >= 2) {
                            int n = i--;
                            uidBytes[n] = (byte)(uidBytes[n] + 1);
                            if (uidBytes[n] != 0) break;
                        }
                        result.set(uidBytes, 0, 14);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.CREATE_QUERY_UID;
    }
}

