/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class OrderedListConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new OrderedListConstructorDescriptor();
        }
    };
    private AOrderedListType oltype;

    public void setImmutableStates(Object ... states) {
        this.oltype = (AOrderedListType)states[0];
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        return new OrderedListConstructorEvaluatorFactory(args, this.oltype);
    }

    private static class OrderedListConstructorEvaluatorFactory
    implements IScalarEvaluatorFactory {
        private static final long serialVersionUID = 1L;
        private IScalarEvaluatorFactory[] args;
        private boolean selfDescList = false;
        private AOrderedListType orderedlistType;

        public OrderedListConstructorEvaluatorFactory(IScalarEvaluatorFactory[] args, AOrderedListType type) {
            this.args = args;
            this.orderedlistType = type;
            if (type == null || type.getItemType() == null || type.getItemType().getTypeTag() == ATypeTag.ANY) {
                this.selfDescList = true;
            }
        }

        public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
            final IScalarEvaluator[] argEvals = new IScalarEvaluator[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                argEvals[i] = this.args[i].createScalarEvaluator(ctx);
            }
            return new IScalarEvaluator(){
                private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                private final DataOutput out = this.resultStorage.getDataOutput();
                private final IPointable inputVal = new VoidPointable();
                private final OrderedListBuilder builder = new OrderedListBuilder();

                public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                    try {
                        this.resultStorage.reset();
                        this.builder.reset((AbstractCollectionType)orderedlistType);
                        if (selfDescList) {
                            this.writeUntypedItems(tuple);
                        } else {
                            this.writeTypedItems(tuple);
                        }
                        this.builder.write(this.out, true);
                        result.set((IValueReference)this.resultStorage);
                    }
                    catch (IOException ioe) {
                        throw new HyracksDataException((Throwable)ioe);
                    }
                }

                private void writeUntypedItems(IFrameTupleReference tuple) throws HyracksDataException {
                    try {
                        for (int i = 0; i < argEvals.length; ++i) {
                            argEvals[i].evaluate(tuple, this.inputVal);
                            this.builder.addItem((IValueReference)this.inputVal);
                        }
                    }
                    catch (IOException ioe) {
                        throw new HyracksDataException((Throwable)ioe);
                    }
                }

                private void writeTypedItems(IFrameTupleReference tuple) throws HyracksDataException {
                    try {
                        for (int i = 0; i < argEvals.length; ++i) {
                            argEvals[i].evaluate(tuple, this.inputVal);
                            this.builder.addItem((IValueReference)this.inputVal);
                        }
                    }
                    catch (IOException ioe) {
                        throw new HyracksDataException((Throwable)ioe);
                    }
                }
            };
        }
    }
}

