/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class AStringConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new AStringConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private UTF8StringBuilder builder;
                    private GrowableArray baaos;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.builder = new UTF8StringBuilder();
                        this.baaos = new GrowableArray();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        try {
                            this.resultStorage.reset();
                            this.baaos.reset();
                            this.eval.evaluate(tuple, this.inputArg);
                            byte[] serString = this.inputArg.getByteArray();
                            int offset = this.inputArg.getStartOffset();
                            int len = this.inputArg.getLength();
                            ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[serString[offset]];
                            if (tt == ATypeTag.STRING) {
                                result.set((IValueReference)this.inputArg);
                            } else {
                                this.builder.reset(this.baaos, len);
                                int startOffset = offset + 1;
                                switch (tt) {
                                    case INT8: {
                                        byte i = AInt8SerializerDeserializer.getByte((byte[])serString, (int)startOffset);
                                        this.builder.appendString(String.valueOf(i));
                                        break;
                                    }
                                    case INT16: {
                                        short i = AInt16SerializerDeserializer.getShort((byte[])serString, (int)startOffset);
                                        this.builder.appendString(String.valueOf(i));
                                        break;
                                    }
                                    case INT32: {
                                        int i = AInt32SerializerDeserializer.getInt((byte[])serString, (int)startOffset);
                                        this.builder.appendString(String.valueOf(i));
                                        break;
                                    }
                                    case INT64: {
                                        long l = AInt64SerializerDeserializer.getLong((byte[])serString, (int)startOffset);
                                        this.builder.appendString(String.valueOf(l));
                                        break;
                                    }
                                    case DOUBLE: {
                                        double d = ADoubleSerializerDeserializer.getDouble((byte[])serString, (int)startOffset);
                                        this.builder.appendString(String.valueOf(d));
                                        break;
                                    }
                                    case FLOAT: {
                                        float f = AFloatSerializerDeserializer.getFloat((byte[])serString, (int)startOffset);
                                        this.builder.appendString(String.valueOf(f));
                                        break;
                                    }
                                    case BOOLEAN: {
                                        boolean b = ABooleanSerializerDeserializer.getBoolean((byte[])serString, (int)startOffset);
                                        this.builder.appendString(String.valueOf(b));
                                        break;
                                    }
                                    default: {
                                        throw new UnsupportedTypeException(AStringConstructorDescriptor.this.getIdentifier(), serString[offset]);
                                    }
                                }
                                this.builder.finish();
                                this.out.write(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                                this.out.write(this.baaos.getByteArray(), 0, this.baaos.getLength());
                                result.set((IValueReference)this.resultStorage);
                            }
                        }
                        catch (IOException e) {
                            throw new InvalidDataFormatException(AStringConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_CONSTRUCTOR;
    }
}

