/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutablePoint3D;
import org.apache.asterix.om.base.APoint3D;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class APoint3DConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new APoint3DConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private AMutablePoint3D aPoint3D;
                    private ISerializerDeserializer<APoint3D> point3DSerde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.aPoint3D = new AMutablePoint3D(0.0, 0.0, 0.0);
                        this.point3DSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.APOINT3D);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        try {
                            this.resultStorage.reset();
                            this.eval.evaluate(tuple, this.inputArg);
                            byte[] serString = this.inputArg.getByteArray();
                            int offset = this.inputArg.getStartOffset();
                            int len = this.inputArg.getLength();
                            if (serString[offset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                throw new TypeMismatchException(APoint3DConstructorDescriptor.this.getIdentifier(), (Integer)0, serString[offset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            this.utf8Ptr.set(serString, offset + 1, len - 1);
                            String s = this.utf8Ptr.toString();
                            int firstCommaIndex = s.indexOf(44);
                            int secondCommaIndex = s.indexOf(44, firstCommaIndex + 1);
                            this.aPoint3D.setValue(Double.parseDouble(s.substring(0, firstCommaIndex)), Double.parseDouble(s.substring(firstCommaIndex + 1, secondCommaIndex)), Double.parseDouble(s.substring(secondCommaIndex + 1, s.length())));
                            this.point3DSerde.serialize((Object)this.aPoint3D, this.out);
                            result.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException e) {
                            throw new InvalidDataFormatException(APoint3DConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_POINT_TYPE_TAG);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.POINT3D_CONSTRUCTOR;
    }
}

