/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.AMutableDuration;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.ADateParserFactory;
import org.apache.asterix.om.base.temporal.ADurationParserFactory;
import org.apache.asterix.om.base.temporal.DurationArithmeticOperations;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class AIntervalStartFromDateConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final FunctionIdentifier FID = BuiltinFunctions.INTERVAL_CONSTRUCTOR_START_FROM_DATE;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new AIntervalStartFromDateConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable argPtr0 = new VoidPointable();
                    private IPointable argPtr1 = new VoidPointable();
                    private IScalarEvaluator eval0;
                    private IScalarEvaluator eval1;
                    private AMutableInterval aInterval;
                    private AMutableDuration aDuration;
                    private ISerializerDeserializer<AInterval> intervalSerde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.aInterval = new AMutableInterval(0L, 0L, 0);
                        this.aDuration = new AMutableDuration(0, 0L);
                        this.intervalSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINTERVAL);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.argPtr0);
                        this.eval1.evaluate(tuple, this.argPtr1);
                        byte[] bytes0 = this.argPtr0.getByteArray();
                        int offset0 = this.argPtr0.getStartOffset();
                        int len0 = this.argPtr0.getLength();
                        byte[] bytes1 = this.argPtr1.getByteArray();
                        int offset1 = this.argPtr1.getStartOffset();
                        int len1 = this.argPtr1.getLength();
                        try {
                            int stringLength;
                            long intervalStart = 0L;
                            long intervalEnd = 0L;
                            if (bytes0[offset0] == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                                intervalStart = (long)ADateSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1)) * 86400000L;
                            } else if (bytes0[offset0] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                this.utf8Ptr.set(bytes0, offset0 + 1, len0 - 1);
                                stringLength = this.utf8Ptr.getUTF8Length();
                                int startOffset = this.utf8Ptr.getCharStartOffset();
                                intervalStart = ADateParserFactory.parseDatePart((byte[])bytes0, (int)startOffset, (int)stringLength);
                            } else {
                                throw new TypeMismatchException(AIntervalStartFromDateConstructorDescriptor.this.getIdentifier(), (Integer)0, bytes0[offset0], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            if (bytes1[offset1] == ATypeTag.SERIALIZED_DURATION_TYPE_TAG) {
                                intervalEnd = DurationArithmeticOperations.addDuration((long)intervalStart, (int)ADurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1)), (long)ADurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1)), (boolean)false);
                            } else if (bytes1[offset1] == ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG) {
                                intervalEnd = DurationArithmeticOperations.addDuration((long)intervalStart, (int)0, (long)ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes1, (int)(offset1 + 1)), (boolean)false);
                            } else if (bytes1[offset1] == ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG) {
                                intervalEnd = DurationArithmeticOperations.addDuration((long)intervalStart, (int)AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes1, (int)(offset1 + 1)), (long)0L, (boolean)false);
                            } else if (bytes1[offset1] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                this.utf8Ptr.set(bytes1, offset1 + 1, len1 - 1);
                                stringLength = this.utf8Ptr.getUTF8Length();
                                ADurationParserFactory.parseDuration((Object)bytes1, (int)this.utf8Ptr.getCharStartOffset(), (int)stringLength, (IAObject)this.aDuration, (ADurationParserFactory.ADurationParseOption)ADurationParserFactory.ADurationParseOption.All);
                                intervalEnd = DurationArithmeticOperations.addDuration((long)intervalStart, (int)this.aDuration.getMonths(), (long)this.aDuration.getMilliseconds(), (boolean)false);
                            } else {
                                throw new TypeMismatchException(AIntervalStartFromDateConstructorDescriptor.this.getIdentifier(), (Integer)1, bytes1[offset1], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            intervalStart = GregorianCalendarSystem.getChrononInDays((long)intervalStart);
                            intervalEnd = GregorianCalendarSystem.getChrononInDays((long)intervalEnd);
                            if (intervalEnd < intervalStart) {
                                throw new InvalidDataFormatException(AIntervalStartFromDateConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                            }
                            this.aInterval.setValue(intervalStart, intervalEnd, ATypeTag.SERIALIZED_DATE_TYPE_TAG);
                            this.intervalSerde.serialize((Object)this.aInterval, this.out);
                        }
                        catch (IOException e) {
                            throw new InvalidDataFormatException(AIntervalStartFromDateConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return FID;
    }
}

