/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class AInt64ConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new AInt64ConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private long value;
                    private int offset;
                    private boolean positive;
                    private AMutableInt64 aInt64;
                    private ISerializerDeserializer<AInt64> int64Serde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.aInt64 = new AMutableInt64(0L);
                        this.int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        try {
                            this.resultStorage.reset();
                            this.eval.evaluate(tuple, this.inputArg);
                            byte[] serString = this.inputArg.getByteArray();
                            int startOffset = this.inputArg.getStartOffset();
                            int len = this.inputArg.getLength();
                            if (serString[startOffset] == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                this.utf8Ptr.set(serString, startOffset + 1, len - 1);
                                this.offset = this.utf8Ptr.getCharStartOffset();
                                this.value = 0L;
                                this.positive = true;
                                long limit = -9223372036854775807L;
                                if (serString[this.offset] == 43) {
                                    ++this.offset;
                                } else if (serString[this.offset] == 45) {
                                    ++this.offset;
                                    this.positive = false;
                                    limit = Long.MIN_VALUE;
                                }
                                int end = startOffset + len;
                                while (this.offset < end) {
                                    if (serString[this.offset] >= 48 && serString[this.offset] <= 57) {
                                        this.value *= 10L;
                                    } else {
                                        if (serString[this.offset] == 105 && serString[this.offset + 1] == 54 && serString[this.offset + 2] == 52 && this.offset + 3 == end) break;
                                        throw new InvalidDataFormatException(AInt64ConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INT64_TYPE_TAG);
                                    }
                                    int digit = serString[this.offset] - 48;
                                    if (this.value < limit + (long)digit) {
                                        throw new InvalidDataFormatException(AInt64ConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INT64_TYPE_TAG);
                                    }
                                    this.value -= (long)digit;
                                    ++this.offset;
                                }
                                if (this.value > 0L) {
                                    throw new InvalidDataFormatException(AInt64ConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INT64_TYPE_TAG);
                                }
                                if (this.value < 0L && this.positive) {
                                    this.value *= -1L;
                                }
                            } else {
                                throw new InvalidDataFormatException(AInt64ConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INT64_TYPE_TAG);
                            }
                            this.aInt64.setValue(this.value);
                            this.int64Serde.serialize((Object)this.aInt64, this.out);
                            result.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException e) {
                            throw new InvalidDataFormatException(AInt64ConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_INT64_TYPE_TAG);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.INT64_CONSTRUCTOR;
    }
}

