/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ISequenceIterator;

public abstract class AbstractAsterixListIterator
implements ISequenceIterator {
    protected byte[] data;
    protected int count = 0;
    protected int pos = -1;
    protected int nextPos = -1;
    protected int itemLen = -1;
    protected int numberOfItems = -1;
    protected int listLength = -1;
    protected int startOff = -1;
    protected IBinaryComparator cmp;
    protected final boolean ignoreCase = true;

    public int compare(ISequenceIterator cmpIter) throws HyracksDataException {
        return this.cmp.compare(this.data, this.pos, -1, cmpIter.getData(), cmpIter.getPos(), -1);
    }

    public boolean hasNext() {
        return this.count < this.numberOfItems;
    }

    public int size() {
        return this.numberOfItems;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getPos() {
        return this.pos;
    }

    public int getItemLen() {
        return this.itemLen;
    }

    public void next() throws HyracksDataException {
        try {
            this.pos = this.nextPos;
            ++this.count;
            this.nextPos = this.startOff + this.listLength;
            if (this.count + 1 < this.numberOfItems) {
                this.nextPos = this.getItemOffset(this.data, this.startOff, this.count + 1);
            }
            this.itemLen = this.nextPos - this.pos;
        }
        catch (AsterixException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void reset() throws HyracksDataException {
        this.count = 0;
        try {
            this.pos = this.getItemOffset(this.data, this.startOff, this.count);
            this.nextPos = this.startOff + this.listLength;
            if (this.count + 1 < this.numberOfItems) {
                this.nextPos = this.getItemOffset(this.data, this.startOff, this.count + 1);
            }
            this.itemLen = this.nextPos - this.pos;
        }
        catch (AsterixException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void reset(byte[] data, int startOff) throws HyracksDataException {
        this.data = data;
        this.startOff = startOff;
        this.numberOfItems = this.getNumberOfItems(data, startOff);
        this.listLength = this.getListLength(data, startOff);
        ATypeTag tag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(data[startOff + 1]);
        switch (tag) {
            case INT64: {
                this.cmp = BinaryComparatorFactoryProvider.LONG_POINTABLE_INSTANCE.createBinaryComparator();
                break;
            }
            case INT32: {
                this.cmp = BinaryComparatorFactoryProvider.INTEGER_POINTABLE_INSTANCE.createBinaryComparator();
                break;
            }
            case INT16: {
                this.cmp = BinaryComparatorFactoryProvider.SHORT_POINTABLE_INSTANCE.createBinaryComparator();
                break;
            }
            case INT8: {
                this.cmp = BinaryComparatorFactoryProvider.BYTE_POINTABLE_INSTANCE.createBinaryComparator();
                break;
            }
            case FLOAT: {
                this.cmp = BinaryComparatorFactoryProvider.FLOAT_POINTABLE_INSTANCE.createBinaryComparator();
                break;
            }
            case DOUBLE: {
                this.cmp = BinaryComparatorFactoryProvider.DOUBLE_POINTABLE_INSTANCE.createBinaryComparator();
                break;
            }
            case STRING: {
                this.cmp = BinaryComparatorFactoryProvider.UTF8STRING_LOWERCASE_POINTABLE_INSTANCE.createBinaryComparator();
                break;
            }
            case BINARY: {
                this.cmp = BinaryComparatorFactoryProvider.BINARY_POINTABLE_INSTANCE.createBinaryComparator();
                break;
            }
            default: {
                this.cmp = null;
            }
        }
        this.reset();
    }

    protected abstract int getItemOffset(byte[] var1, int var2, int var3) throws AsterixException;

    protected abstract int getNumberOfItems(byte[] var1, int var2);

    protected abstract int getListLength(byte[] var1, int var2);
}

