/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.aggregates.std.AbstractMinMaxAggregateFunction;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class MinMaxAggregateFunction
extends AbstractMinMaxAggregateFunction {
    private final boolean isLocalAgg;

    public MinMaxAggregateFunction(IScalarEvaluatorFactory[] args, IHyracksTaskContext context, boolean isMin, boolean isLocalAgg) throws HyracksDataException {
        super(args, context, isMin);
        this.isLocalAgg = isLocalAgg;
    }

    @Override
    protected void processNull() {
        this.aggType = ATypeTag.NULL;
    }

    @Override
    protected boolean skipStep() {
        return this.aggType == ATypeTag.NULL;
    }

    @Override
    protected void processSystemNull() throws HyracksDataException {
        if (this.isLocalAgg) {
            throw new UnsupportedItemTypeException("min/max", ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
        }
    }

    @Override
    protected void finishSystemNull() throws IOException {
        if (this.isLocalAgg) {
            this.resultStorage.getDataOutput().writeByte(ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
        } else {
            this.resultStorage.getDataOutput().writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
        }
    }
}

