/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.tuples;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleReference;

public class LSMBTreeTupleReference
extends TypeAwareTupleReference
implements ILSMTreeTupleReference {
    private boolean resetFieldCount = false;
    private final int numKeyFields;

    public LSMBTreeTupleReference(ITypeTraits[] typeTraits, int numKeyFields) {
        super(typeTraits);
        this.numKeyFields = numKeyFields;
    }

    public void setFieldCount(int fieldCount) {
        super.setFieldCount(fieldCount);
        this.resetFieldCount = false;
    }

    public void setFieldCount(int fieldStartIndex, int fieldCount) {
        super.setFieldCount(fieldStartIndex, fieldCount);
        this.resetFieldCount = false;
    }

    public void resetByTupleOffset(byte[] buf, int tupleStartOff) {
        this.buf = buf;
        this.tupleStartOff = tupleStartOff;
        if (this.numKeyFields != this.typeTraits.length) {
            if (this.isAntimatter()) {
                this.setFieldCount(this.numKeyFields);
                this.resetFieldCount = true;
            } else if (this.resetFieldCount) {
                this.setFieldCount(this.typeTraits.length);
            }
        }
        super.resetByTupleOffset(buf, tupleStartOff);
    }

    public void resetByTupleIndex(ITreeIndexFrame frame, int tupleIndex) {
        this.resetByTupleOffset(frame.getBuffer().array(), frame.getTupleOffset(tupleIndex));
    }

    protected int getNullFlagsBytes() {
        return (int)Math.ceil(((double)this.fieldCount + 1.0) / 8.0);
    }

    public boolean isAntimatter() {
        int mask = -128;
        return (this.buf[this.tupleStartOff] & 0xFFFFFF80) != 0;
    }

    public int getTupleStart() {
        return this.tupleStartOff;
    }
}

