/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyAbstractCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;

public class LSMBTreeWithBuddySearchCursor
extends LSMBTreeWithBuddyAbstractCursor {
    private int currentCursor = 0;
    private PermutingTupleReference buddyBTreeTuple;

    public LSMBTreeWithBuddySearchCursor(ILSMIndexOperationContext opCtx, int[] buddyBTreeFields) {
        super(opCtx);
        this.buddyBTreeTuple = new PermutingTupleReference(buddyBTreeFields);
    }

    @Override
    public void close() throws HyracksDataException {
        super.close();
        this.currentCursor = 0;
    }

    public void reset() throws HyracksDataException {
        if (!this.open) {
            return;
        }
        this.currentCursor = 0;
        this.foundNext = false;
        try {
            for (int i = 0; i < this.numberOfTrees; ++i) {
                this.btreeCursors[i].close();
                this.buddyBtreeCursors[i].close();
            }
            this.btreeCursors = null;
            this.buddyBtreeCursors = null;
        }
        finally {
            this.lsmHarness.endSearch(this.opCtx);
        }
    }

    private void searchNextCursor() throws HyracksDataException {
        if (this.currentCursor < this.numberOfTrees) {
            try {
                this.btreeCursors[this.currentCursor].reset();
                this.btreeAccessors[this.currentCursor].search((IIndexCursor)this.btreeCursors[this.currentCursor], (ISearchPredicate)this.btreeRangePredicate);
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() throws HyracksDataException, IndexException {
        if (this.foundNext) {
            return true;
        }
        while (this.currentCursor < this.numberOfTrees) {
            while (this.btreeCursors[this.currentCursor].hasNext()) {
                this.btreeCursors[this.currentCursor].next();
                ITupleReference currentTuple = this.btreeCursors[this.currentCursor].getTuple();
                this.buddyBTreeTuple.reset(this.btreeCursors[this.currentCursor].getTuple());
                boolean killerTupleFound = false;
                for (int i = 0; i < this.currentCursor; ++i) {
                    this.buddyBtreeCursors[i].reset();
                    this.buddyBtreeRangePredicate.setHighKey((ITupleReference)this.buddyBTreeTuple, true);
                    this.buddyBtreeRangePredicate.setLowKey((ITupleReference)this.buddyBTreeTuple, true);
                    this.buddyBtreeAccessors[i].search((IIndexCursor)this.buddyBtreeCursors[i], (ISearchPredicate)this.buddyBtreeRangePredicate);
                    try {
                        if (!this.buddyBtreeCursors[i].hasNext()) continue;
                        killerTupleFound = true;
                        break;
                    }
                    finally {
                        this.buddyBtreeCursors[i].close();
                    }
                }
                if (killerTupleFound) continue;
                this.frameTuple = currentTuple;
                this.foundNext = true;
                return true;
            }
            this.btreeCursors[this.currentCursor].close();
            ++this.currentCursor;
            this.searchNextCursor();
        }
        return false;
    }

    public void next() throws HyracksDataException {
        this.foundNext = false;
    }

    @Override
    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException, IndexException {
        super.open(initialState, searchPred);
        this.searchNextCursor();
    }
}

