/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;

public class LSMBTreeWithBuddyMergeOperation
implements ILSMIOOperation {
    private final ILSMIndexAccessor accessor;
    private final List<ILSMComponent> mergingComponents;
    private final ITreeIndexCursor cursor;
    private final FileReference btreeMergeTarget;
    private final FileReference buddyBtreeMergeTarget;
    private final FileReference bloomFilterMergeTarget;
    private final ILSMIOOperationCallback callback;
    private final String indexIdentifier;
    private final boolean keepDeletedTuples;

    public LSMBTreeWithBuddyMergeOperation(ILSMIndexAccessor accessor, List<ILSMComponent> mergingComponents, ITreeIndexCursor cursor, FileReference btreeMergeTarget, FileReference buddyBtreeMergeTarget, FileReference bloomFilterMergeTarget, ILSMIOOperationCallback callback, String indexIdentifier, boolean keepDeletedTuples) {
        this.accessor = accessor;
        this.mergingComponents = mergingComponents;
        this.cursor = cursor;
        this.btreeMergeTarget = btreeMergeTarget;
        this.buddyBtreeMergeTarget = buddyBtreeMergeTarget;
        this.bloomFilterMergeTarget = bloomFilterMergeTarget;
        this.callback = callback;
        this.indexIdentifier = indexIdentifier;
        this.keepDeletedTuples = keepDeletedTuples;
    }

    public Set<IODeviceHandle> getReadDevices() {
        HashSet<IODeviceHandle> devs = new HashSet<IODeviceHandle>();
        for (ILSMComponent o : this.mergingComponents) {
            LSMBTreeWithBuddyDiskComponent component = (LSMBTreeWithBuddyDiskComponent)o;
            devs.add(component.getBTree().getFileReference().getDeviceHandle());
            devs.add(component.getBuddyBTree().getFileReference().getDeviceHandle());
            devs.add(component.getBloomFilter().getFileReference().getDeviceHandle());
        }
        return devs;
    }

    public Set<IODeviceHandle> getWriteDevices() {
        HashSet<IODeviceHandle> devs = new HashSet<IODeviceHandle>();
        devs.add(this.btreeMergeTarget.getDeviceHandle());
        devs.add(this.buddyBtreeMergeTarget.getDeviceHandle());
        devs.add(this.bloomFilterMergeTarget.getDeviceHandle());
        return devs;
    }

    public Boolean call() throws HyracksDataException, IndexException {
        this.accessor.merge((ILSMIOOperation)this);
        return true;
    }

    public ILSMIOOperationCallback getCallback() {
        return this.callback;
    }

    public String getIndexUniqueIdentifier() {
        return this.indexIdentifier;
    }

    public ILSMIOOperation.LSMIOOpertionType getIOOpertionType() {
        return ILSMIOOperation.LSMIOOpertionType.MERGE;
    }

    public FileReference getBTreeMergeTarget() {
        return this.btreeMergeTarget;
    }

    public FileReference getBuddyBTreeMergeTarget() {
        return this.buddyBtreeMergeTarget;
    }

    public FileReference getBloomFilterMergeTarget() {
        return this.bloomFilterMergeTarget;
    }

    public ITreeIndexCursor getCursor() {
        return this.cursor;
    }

    public List<ILSMComponent> getMergingComponents() {
        return this.mergingComponents;
    }

    public boolean isKeepDeletedTuples() {
        return this.keepDeletedTuples;
    }
}

