/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMDiskComponent;

public class LSMBTreeWithBuddyDiskComponent
extends AbstractLSMDiskComponent {
    private final BTree btree;
    private final BTree buddyBtree;
    private final BloomFilter bloomFilter;

    public LSMBTreeWithBuddyDiskComponent(BTree btree, BTree buddyBtree, BloomFilter bloomFilter, ILSMComponentFilter filter) {
        super((IMetadataPageManager)btree.getPageManager(), filter);
        this.btree = btree;
        this.buddyBtree = buddyBtree;
        this.bloomFilter = bloomFilter;
    }

    public void destroy() throws HyracksDataException {
        this.btree.deactivate();
        this.btree.destroy();
        this.buddyBtree.deactivate();
        this.buddyBtree.destroy();
        this.bloomFilter.deactivate();
        this.bloomFilter.destroy();
    }

    public BTree getBTree() {
        return this.btree;
    }

    public BTree getBuddyBTree() {
        return this.buddyBtree;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public long getComponentSize() {
        long size = this.btree.getFileReference().getFile().length();
        size += this.buddyBtree.getFileReference().getFile().length();
        return size += this.bloomFilter.getFileReference().getFile().length();
    }

    public int getFileReferenceCount() {
        return this.btree.getBufferCache().getFileReferenceCount(this.btree.getFileId());
    }
}

